/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.kotlin.pleaseanimate.core.custom;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.github.florent37.kotlin.pleaseanimate.core.Utils;
import com.github.florent37.kotlin.pleaseanimate.core.custom.CustomAnimExpectation;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/florent37/kotlin/pleaseanimate/core/custom/TextSizeAnimExpectation;", "Lcom/github/florent37/kotlin/pleaseanimate/core/custom/CustomAnimExpectation;", "endSize", "", "(F)V", "getAnimator", "Landroid/animation/Animator;", "viewToMove", "Landroid/view/View;", "kotlinpleaseanimate_release"})
public final class TextSizeAnimExpectation
extends CustomAnimExpectation {
    private final float endSize;

    @Override
    @Nullable
    public Animator getAnimator(@NotNull View viewToMove) {
        Animator animator;
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (viewToMove instanceof TextView) {
            ValueAnimator valueAnimator;
            Context context = ((TextView)viewToMove).getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"viewToMove.context");
            float startSize = Utils.INSTANCE.spToDp(context, ((TextView)viewToMove).getTextSize());
            ValueAnimator $receiver = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{startSize, this.endSize});
            $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(viewToMove){
                final /* synthetic */ View $viewToMove$inlined;
                {
                    this.$viewToMove$inlined = view;
                }

                public final void onAnimationUpdate(ValueAnimator it) {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float value = ((Float)object).floatValue();
                    ((TextView)this.$viewToMove$inlined).setTextSize(value);
                }
            });
            animator = (Animator)valueAnimator;
        } else {
            animator = null;
        }
        return animator;
    }

    public TextSizeAnimExpectation(float endSize) {
        this.endSize = endSize;
    }
}

