/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.kotlin.pleaseanimate.core.position;

import android.view.View;
import android.view.ViewParent;
import com.github.florent37.kotlin.pleaseanimate.ViewCalculator;
import com.github.florent37.kotlin.pleaseanimate.core.position.PositionAnimationViewDependant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimExpectationCenterBetweenViewAndParent;", "Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimationViewDependant;", "otherView", "Landroid/view/View;", "horizontal", "", "vertical", "toBeOnRight", "toBeOnBottom", "(Landroid/view/View;ZZZZ)V", "getCalculatedValueX", "", "viewToMove", "(Landroid/view/View;)Ljava/lang/Float;", "getCalculatedValueY", "kotlinpleaseanimate_release"})
public final class PositionAnimExpectationCenterBetweenViewAndParent
extends PositionAnimationViewDependant {
    private final boolean horizontal;
    private final boolean vertical;
    private final boolean toBeOnRight;
    private final boolean toBeOnBottom;

    @Override
    @Nullable
    public Float getCalculatedValueX(@NotNull View viewToMove) {
        ViewParent viewParent;
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.horizontal && (viewParent = this.getOtherView().getParent()) instanceof View && this.horizontal) {
            View parentView = (View)viewParent;
            ViewCalculator viewCalculator = this.getViewCalculator();
            if (viewCalculator == null) {
                Intrinsics.throwNpe();
            }
            float centerOfOtherView = viewCalculator.finalCenterXOfView(this.getOtherView());
            if (this.toBeOnRight) {
                float parentWidth = parentView.getWidth();
                return Float.valueOf((parentWidth + centerOfOtherView) / 2.0f - (float)viewToMove.getWidth() / 2.0f);
            }
            return Float.valueOf(centerOfOtherView / 2.0f - (float)viewToMove.getWidth() / 2.0f);
        }
        return null;
    }

    @Override
    @Nullable
    public Float getCalculatedValueY(@NotNull View viewToMove) {
        ViewParent viewParent;
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.vertical && (viewParent = viewToMove.getParent()) instanceof View && this.vertical) {
            View parentView = (View)viewParent;
            ViewCalculator viewCalculator = this.getViewCalculator();
            if (viewCalculator == null) {
                Intrinsics.throwNpe();
            }
            float centerOfOtherView = viewCalculator.finalCenterYOfView(this.getOtherView());
            if (this.toBeOnBottom) {
                float parentHeight = parentView.getHeight();
                return Float.valueOf(parentHeight + centerOfOtherView / 2.0f - (float)viewToMove.getHeight() / 2.0f);
            }
            return Float.valueOf(centerOfOtherView / 2.0f - (float)viewToMove.getHeight() / 2.0f);
        }
        return null;
    }

    public PositionAnimExpectationCenterBetweenViewAndParent(@NotNull View otherView, boolean horizontal, boolean vertical, boolean toBeOnRight, boolean toBeOnBottom) {
        Intrinsics.checkParameterIsNotNull((Object)otherView, (String)"otherView");
        super(otherView);
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.toBeOnRight = toBeOnRight;
        this.toBeOnBottom = toBeOnBottom;
        this.setForPositionY(true);
        this.setForPositionX(true);
    }
}

