/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.inlineactivityresult;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import com.github.florent37.inlineactivityresult.request.Request;
import com.github.florent37.inlineactivityresult.request.RequestFabric;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ActivityResultFragment
extends Fragment {
    private static final String INTENT_TO_START = "INTENT_TO_START";
    private static final int REQUEST_CODE = 24;
    @Nullable
    private Request request;
    @Nullable
    private ActivityResultListener listener;

    public ActivityResultFragment() {
        this.setRetainInstance(true);
    }

    public static ActivityResultFragment newInstance(@NonNull Intent intent, @Nullable ActivityResultListener listener) {
        return ActivityResultFragment.newInstance(RequestFabric.create(intent), listener);
    }

    public static ActivityResultFragment newInstance(@NonNull Request request, @Nullable ActivityResultListener listener) {
        ActivityResultFragment fragment = new ActivityResultFragment();
        fragment.setRequest(request);
        fragment.setListener(listener);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loadArguments();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.executeRequest();
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 24) {
            if (this.listener != null) {
                this.listener.onActivityResult(requestCode, resultCode, data);
            }
            this.removeFragment();
        }
    }

    public void executeRequest() {
        if (this.request != null) {
            try {
                this.request.execute(this, 24);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.listener != null) {
                    this.listener.error(e);
                }
                this.removeFragment();
            }
        } else {
            if (this.listener != null) {
                this.listener.error(new NullPointerException("request is empty"));
            }
            this.removeFragment();
        }
    }

    private void setRequest(@NonNull Request request) {
        this.request = request;
        this.saveArguments();
    }

    private void setListener(@Nullable ActivityResultListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    private void removeFragment() {
        if (this.getFragmentManager() != null) {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    private void loadArguments() {
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.request = (Request)arguments.getParcelable(INTENT_TO_START);
        }
    }

    private void saveArguments() {
        Bundle args = new Bundle();
        args.putParcelable(INTENT_TO_START, (Parcelable)this.request);
        this.setArguments(args);
    }

    private int checkForValidRequestCode(int requestCode) {
        if ((requestCode & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode=" + requestCode);
        }
        return requestCode;
    }

    static interface ActivityResultListener {
        public void onActivityResult(int var1, int var2, Intent var3);

        public void error(Throwable var1);
    }
}

