/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.inlineactivityresult;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.github.florent37.inlineactivityresult.ActivityResultFragment;
import com.github.florent37.inlineactivityresult.Result;
import com.github.florent37.inlineactivityresult.callbacks.ActivityResultListener;
import com.github.florent37.inlineactivityresult.callbacks.FailCallback;
import com.github.florent37.inlineactivityresult.callbacks.SuccessCallback;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class InlineActivityResult {
    private static final String TAG = "ACTIVITY_RESULT_FRAGMENT_WEEEEE";
    private final Reference<FragmentActivity> activityReference;
    private final List<ActivityResultListener> responseListeners = new ArrayList<ActivityResultListener>();
    private final List<SuccessCallback> successCallbacks = new ArrayList<SuccessCallback>();
    private final List<FailCallback> failCallbacks = new ArrayList<FailCallback>();
    private final ActivityResultFragment.ActivityResultListener listener = new ActivityResultFragment.ActivityResultListener(){

        @Override
        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            InlineActivityResult.this.onReceivedActivityResult(requestCode, resultCode, data);
        }
    };

    public static InlineActivityResult startForResult(FragmentActivity activity, @Nullable Intent intent, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(activity).startForResult(intent, listener);
    }

    public static InlineActivityResult startForResult(Fragment fragment, @Nullable Intent intent, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(fragment).startForResult(intent, listener);
    }

    public InlineActivityResult(@Nullable FragmentActivity activity) {
        this.activityReference = activity != null ? new WeakReference<FragmentActivity>(activity) : new WeakReference<Object>(null);
    }

    public InlineActivityResult(@Nullable Fragment fragment) {
        FragmentActivity activity = null;
        if (fragment != null) {
            activity = fragment.getActivity();
        }
        this.activityReference = activity != null ? new WeakReference<FragmentActivity>(activity) : new WeakReference<Object>(null);
    }

    private void onReceivedActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block5: {
            Result result;
            block4: {
                result = new Result(this, requestCode, resultCode, data);
                if (resultCode != -1) break block4;
                for (SuccessCallback callback : this.successCallbacks) {
                    callback.onSuccess(result);
                }
                for (ActivityResultListener listener : this.responseListeners) {
                    listener.onSuccess(result);
                }
                break block5;
            }
            if (resultCode != 0) break block5;
            for (FailCallback callback : this.failCallbacks) {
                callback.onFailed(result);
            }
            for (ActivityResultListener listener : this.responseListeners) {
                listener.onFailed(result);
            }
        }
    }

    public InlineActivityResult startForResult(@Nullable Intent intent) {
        if (intent != null) {
            this.start(intent);
        }
        return this;
    }

    public InlineActivityResult startForResult(@Nullable Intent intent, @Nullable ActivityResultListener listener) {
        if (intent != null && listener != null) {
            this.responseListeners.add(listener);
            this.start(intent);
        }
        return this;
    }

    public InlineActivityResult onSuccess(@Nullable SuccessCallback callback) {
        if (callback != null) {
            this.successCallbacks.add(callback);
        }
        return this;
    }

    public InlineActivityResult onFail(@Nullable FailCallback callback) {
        if (callback != null) {
            this.failCallbacks.add(callback);
        }
        return this;
    }

    private void start(@NonNull Intent intent) {
        final FragmentActivity activity = this.activityReference.get();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        ActivityResultFragment oldFragment = (ActivityResultFragment)activity.getSupportFragmentManager().findFragmentByTag(TAG);
        if (oldFragment != null) {
            oldFragment.setListener(this.listener);
        } else {
            final ActivityResultFragment newFragment = ActivityResultFragment.newInstance(intent);
            newFragment.setListener(this.listener);
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    activity.getSupportFragmentManager().beginTransaction().add((Fragment)newFragment, InlineActivityResult.TAG).commitNowAllowingStateLoss();
                }
            });
        }
    }
}

