/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.androidnosql;

import com.github.florent37.androidnosql.NoSql;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoSqlSerializerUtils {
    public static boolean isValueObject(Object object) {
        return NoSqlSerializerUtils.isPrimitiveObject(object) || object instanceof NoSql.Node;
    }

    public static Class genericType(Field field) {
        ParameterizedType listType = (ParameterizedType)field.getGenericType();
        Class listClass = (Class)listType.getActualTypeArguments()[0];
        return listClass;
    }

    public static boolean isPrimitiveObject(Object object) {
        return object instanceof String || object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Long;
    }

    public static boolean isPrimitiveField(Field field) {
        return NoSqlSerializerUtils.isPrimitive(field.getType());
    }

    public static boolean isPrimitive(Class type) {
        return Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || String.class.isAssignableFrom(type);
    }

    public static boolean isCollection(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    public static boolean isArray(Field field) {
        return field.getType().isArray();
    }

    public static boolean isInterface(Field field) {
        return field.getType().isInterface();
    }

    public static Set<Field> getAllFields(Class theClass) {
        HashSet<Field> allFields = new HashSet<Field>();
        for (Class tmpClass = theClass; tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
            allFields.addAll(Arrays.asList(tmpClass.getDeclaredFields()));
        }
        return allFields;
    }
}

