/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.androidnosql;

import android.util.Pair;
import com.github.florent37.androidnosql.AndroidNoSql;
import com.github.florent37.androidnosql.Listener;
import com.github.florent37.androidnosql.NoSqlSerializerUtils;
import com.github.florent37.androidnosql.datasaver.DataSaver;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NoSql {
    public static final String PATH_SEPARATOR = "/";
    private static NoSql INSTANCE;
    public boolean autoSave = true;
    private Map<String, Reference<Listener>> listeners = new HashMap<String, Reference<Listener>>();
    private Node root = new Node("");

    private NoSql() {
    }

    public static NoSql getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NoSql();
        }
        return INSTANCE;
    }

    private Node getNodeOrCreate(String completeFieldPath) {
        Pair<Node, String> nodeDesc = this.getNode(completeFieldPath);
        return this.getOrCreate((Node)nodeDesc.first, (String)nodeDesc.second);
    }

    public NoSql remove(String path) {
        if (path.equals(PATH_SEPARATOR)) {
            this.root.removeAll();
        } else {
            Pair<Node, String> nodeDesc = this.getNode(path);
            ((Node)nodeDesc.first).remove((String)nodeDesc.second);
        }
        if (this.autoSave) {
            for (DataSaver dataSaver : AndroidNoSql.getDataSaver()) {
                dataSaver.remove(path);
            }
        }
        return this;
    }

    private Node getOrCreate(Node node, String name) {
        if (node.has(name)) {
            if (node.get(name) instanceof Node) {
                return node.child(name);
            }
            return null;
        }
        Node node1 = new Node(node.path + PATH_SEPARATOR + name);
        node.put(name, node1);
        return node1;
    }

    private NodeDescritption split(String uri) {
        uri = uri.replace("//", PATH_SEPARATOR);
        String[] strings = uri.split(PATH_SEPARATOR);
        ArrayList<String> path = new ArrayList<String>();
        for (String string : strings) {
            if (string.length() <= 0) continue;
            path.add(string);
        }
        int indexLast = path.size() - 1;
        String name = (String)path.get(indexLast);
        path.remove(indexLast);
        return new NodeDescritption(path, name);
    }

    public Value get(String uri) {
        Pair<Node, String> node_and_name = this.getNode(uri);
        Node node = (Node)node_and_name.first;
        String name = (String)node_and_name.second;
        return node.value(name);
    }

    public Pair<Node, String> getNode(String uri) {
        Node node = this.root;
        NodeDescritption nodeDescritption = this.split(uri);
        for (String nodeName : nodeDescritption.path) {
            node = this.getOrCreate(node, nodeName);
        }
        return Pair.create((Object)node, (Object)nodeDescritption.name);
    }

    public void load() {
        Collection<DataSaver> dataSavers = AndroidNoSql.getDataSaver();
        if (!dataSavers.isEmpty()) {
            for (DataSaver dataSaver : dataSavers) {
                Set<String> nodes = dataSaver.getNodes();
                if (nodes == null) continue;
                for (String node : nodes) {
                    Object value = dataSaver.getValue(node);
                    if (value == null) continue;
                    this.put(node, value);
                }
            }
        }
    }

    public NoSql reset() {
        this.root = new Node("");
        this.clearDataSavers();
        return this;
    }

    public NoSql clearDataSavers() {
        AndroidNoSql.clearDataSavers();
        return this;
    }

    public NoSql save() {
        this.clearDataSavers();
        this.root.save(AndroidNoSql.getDataSaver());
        return this;
    }

    public NoSql put(String uri, Object value) {
        Pair<Node, String> node_and_name = this.getNode(uri);
        Node node = (Node)node_and_name.first;
        String name = (String)node_and_name.second;
        if (NoSqlSerializerUtils.isValueObject(value)) {
            node.put(name, value);
            this.notifyListeners(node.path + PATH_SEPARATOR + name);
        } else {
            this.getOrCreate(node, name).write(value);
        }
        if (this.autoSave) {
            node.save(AndroidNoSql.getDataSaver());
        }
        return this;
    }

    private void notifyListeners(String path) {
        for (String key : this.listeners.keySet()) {
            Listener listenerValue;
            Reference<Listener> listener;
            if (!path.startsWith(key) || (listener = this.listeners.get(key)) == null || (listenerValue = listener.get()) == null) continue;
            listenerValue.nodeChanged(path, this.get(path));
        }
    }

    public <T> T get(String path, Class<T> aClass) {
        try {
            T instance = aClass.newInstance();
            Set<Field> fields = NoSqlSerializerUtils.getAllFields(aClass);
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                String completeFieldPath = path + PATH_SEPARATOR + fieldName;
                if (NoSqlSerializerUtils.isPrimitiveField(field)) {
                    Value value = this.get(completeFieldPath);
                    Object fetchedValue = value.object();
                    try {
                        field.set(instance, fetchedValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (NoSqlSerializerUtils.isArray(field)) continue;
                if (NoSqlSerializerUtils.isCollection(field)) {
                    List list = NoSqlSerializerUtils.isInterface(field) ? new ArrayList() : (List)field.getType().newInstance();
                    Node node = this.getNodeOrCreate(completeFieldPath);
                    Class childClass = NoSqlSerializerUtils.genericType(field);
                    if (NoSqlSerializerUtils.isPrimitive(childClass)) {
                        for (String key : node.values.keySet()) {
                            list.add(node.get(key));
                        }
                    } else {
                        for (String key : node.values.keySet()) {
                            String pathChild = completeFieldPath + PATH_SEPARATOR + key;
                            T child = this.get(pathChild, childClass);
                            list.add(child);
                        }
                    }
                    try {
                        field.set(instance, list);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Object child = this.get(completeFieldPath, field.getType());
                try {
                    field.set(instance, child);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void notify(String path, Listener listener) {
        this.listeners.put(path, new SoftReference<Listener>(listener));
    }

    public void removeNotifier(Listener listener) {
        for (String key : this.listeners.keySet()) {
            Reference<Listener> listenerReference = this.listeners.get(key);
            if (!listener.equals(listenerReference.get())) continue;
            this.listeners.remove(key);
            break;
        }
    }

    public Node node(String path) {
        return this.getNodeOrCreate(path);
    }

    private class NodeDescritption {
        final List<String> path;
        final String name;

        public NodeDescritption(List<String> path, String name) {
            this.path = path;
            this.name = name;
        }
    }

    public class Node {
        private final String path;
        private final Map<String, Object> values;

        public Node(String path) {
            this.path = path;
            this.values = new HashMap<String, Object>();
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path + " - " + this.values.toString();
        }

        public Object get(String key) {
            if (this.values.containsKey(key)) {
                return this.values.get(key);
            }
            Node node = new Node(this.path + NoSql.PATH_SEPARATOR + key);
            this.values.put(key, node);
            return node;
        }

        public boolean has(String key) {
            return this.values.containsKey(key);
        }

        public Collection<String> keys() {
            return this.values.keySet();
        }

        public List<Node> childNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String key : this.keys()) {
                Object child = this.values.get(key);
                if (!(child instanceof Node)) continue;
                nodes.add((Node)child);
            }
            return nodes;
        }

        public Node child(String key) {
            return (Node)this.get(key);
        }

        public void put(String name, Object node) {
            this.values.put(name, node);
            if (NoSql.this.autoSave) {
                this.save(AndroidNoSql.getDataSaver());
            }
        }

        public void save(Collection<DataSaver> dataSaver) {
            String p = this.path + NoSql.PATH_SEPARATOR;
            Set<String> keys = this.values.keySet();
            for (DataSaver saver : dataSaver) {
                saver.saveNodes(p, keys);
            }
            for (String key : this.values.keySet()) {
                Object value = this.values.get(key);
                String completePath = this.path + NoSql.PATH_SEPARATOR + key;
                if (NoSqlSerializerUtils.isPrimitiveObject(value)) {
                    for (DataSaver saver : dataSaver) {
                        saver.saveValue(completePath, value);
                    }
                    continue;
                }
                if (!(value instanceof Node)) continue;
                ((Node)value).save(dataSaver);
            }
        }

        public void remove(String key) {
            this.values.remove(key);
        }

        public void removeAll() {
            this.values.clear();
        }

        public Value value(String key) {
            return new Value(this.get(key));
        }

        protected void write(Object value) {
            if (value instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)value;
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    try {
                        Object childObject = jsonObject.get(key);
                        if (NoSqlSerializerUtils.isValueObject(childObject)) {
                            this.put(key, childObject);
                            NoSql.this.notifyListeners(key);
                            continue;
                        }
                        this.child(key).write(childObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            } else if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                int length = jsonArray.length();
                for (int i = 0; i < length; ++i) {
                    try {
                        Object childObject = jsonArray.get(i);
                        String key = String.valueOf(i);
                        if (NoSqlSerializerUtils.isValueObject(childObject)) {
                            this.put(key, childObject);
                            NoSql.this.notifyListeners(key);
                            continue;
                        }
                        this.child(key).write(childObject);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Set<Field> allFields = NoSqlSerializerUtils.getAllFields(value.getClass());
                for (Field field : allFields) {
                    field.setAccessible(true);
                    try {
                        int index;
                        String fieldName = field.getName();
                        Object fieldValue = field.get(value);
                        if (fieldValue == null) continue;
                        String completePath = this.path + NoSql.PATH_SEPARATOR + fieldName;
                        if (NoSqlSerializerUtils.isValueObject(fieldValue)) {
                            this.put(fieldName, fieldValue);
                            NoSql.this.notifyListeners(completePath);
                            continue;
                        }
                        Node node1 = new Node(completePath);
                        this.put(fieldName, node1);
                        if (NoSqlSerializerUtils.isCollection(field)) {
                            Iterable collection = (Iterable)field.get(value);
                            index = 0;
                            for (Object childObject : collection) {
                                String key = String.valueOf(index);
                                if (NoSqlSerializerUtils.isValueObject(childObject)) {
                                    node1.put(key, childObject);
                                    NoSql.this.notifyListeners(key);
                                } else {
                                    node1.child(key).write(childObject);
                                }
                                ++index;
                            }
                            continue;
                        }
                        if (NoSqlSerializerUtils.isArray(field)) {
                            Object[] array = (Object[])field.get(value);
                            index = 0;
                            for (Object childObject : array) {
                                String key = String.valueOf(index);
                                if (NoSqlSerializerUtils.isValueObject(childObject)) {
                                    node1.put(key, childObject);
                                    NoSql.this.notifyListeners(key);
                                } else {
                                    node1.child(key).write(childObject);
                                }
                                ++index;
                            }
                            continue;
                        }
                        node1.write(fieldValue);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            NoSql.this.notifyListeners(this.path);
        }
    }

    public static class Value {
        private final Object object;

        public Value(Object object) {
            this.object = object;
        }

        public Object object() {
            return this.object;
        }

        public boolean isNode() {
            return this.object instanceof Node;
        }

        public Node node() {
            return (Node)this.object;
        }

        public String string() {
            return String.valueOf(this.object);
        }

        public Boolean bool() {
            if (this.object instanceof Boolean) {
                return (Boolean)this.object;
            }
            return null;
        }

        public Integer integer() {
            if (this.object instanceof Integer) {
                return (Integer)this.object;
            }
            return null;
        }

        public String toString() {
            return this.object.toString();
        }
    }
}

