/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.androidnosql;

import android.content.Context;
import com.github.florent37.androidnosql.NoSql;
import com.github.florent37.androidnosql.datasaver.DataSaver;
import com.github.florent37.androidnosql.datasaver.SharedPreferencesDataSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class AndroidNoSql {
    private static final Queue<DataSaver> dataSavers = new LinkedBlockingDeque<DataSaver>();

    public static Collection<DataSaver> getDataSaver() {
        return new ArrayList<DataSaver>(dataSavers);
    }

    public static NoSql getInstance() {
        return NoSql.getInstance();
    }

    public static void initWith(DataSaver ... savers) {
        for (DataSaver saver : savers) {
            AndroidNoSql.addDataSaver(saver);
        }
    }

    public static void initWithDefault(Context context) {
        AndroidNoSql.initWith(new SharedPreferencesDataSaver(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDataSaver(DataSaver saver) {
        Queue<DataSaver> queue = dataSavers;
        synchronized (queue) {
            boolean wasEmpty = dataSavers.isEmpty();
            dataSavers.add(saver);
            if (wasEmpty && !dataSavers.isEmpty()) {
                NoSql noSql = NoSql.getInstance();
                noSql.load();
            }
        }
    }

    public static void clearDataSavers() {
        for (DataSaver dataSaver : AndroidNoSql.getDataSaver()) {
            dataSaver.remove("/");
        }
    }
}

