/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import android.widget.OverScroller;
import androidx.core.view.NestedScrollingChild3;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J,\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0016J4\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00112\b\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\bH\u0016J2\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0016J:\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\bH\u0016JB\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010+\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020\u0018H\u0002J\b\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0017J\b\u00101\u001a\u00020\u0018H\u0002J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u001aH\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\bH\u0016J\u0018\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\b\u00106\u001a\u00020\u0018H\u0016J\u0010\u00106\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/flarelane/webview/NestedScrollWebView;", "Landroid/webkit/WebView;", "Landroidx/core/view/NestedScrollingChild3;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mChildHelper", "Landroidx/core/view/NestedScrollingChildHelper;", "mLastMotionY", "mLastScrollerY", "mMaximumVelocity", "mMinimumVelocity", "mScrollConsumed", "", "mScrollOffset", "mScroller", "Landroid/widget/OverScroller;", "mVelocityTracker", "Landroid/view/VelocityTracker;", "computeScroll", "", "dispatchNestedFling", "", "velocityX", "", "velocityY", "consumed", "dispatchNestedPreFling", "dispatchNestedPreScroll", "dx", "dy", "offsetInWindow", "type", "dispatchNestedScroll", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "fling", "hasNestedScrollingParent", "initVelocityTrackerIfNotExists", "isNestedScrollingEnabled", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "recycleVelocityTracker", "setNestedScrollingEnabled", "enabled", "startNestedScroll", "axes", "stopNestedScroll", "FlareLane_release"})
public final class NestedScrollWebView
extends WebView
implements NestedScrollingChild3 {
    @NotNull
    private final int[] mScrollConsumed;
    @NotNull
    private final int[] mScrollOffset;
    private int mLastMotionY;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private final int mMinimumVelocity;
    private final int mMaximumVelocity;
    @NotNull
    private final OverScroller mScroller;
    private int mLastScrollerY;
    @NotNull
    private final NestedScrollingChildHelper mChildHelper;

    @JvmOverloads
    public NestedScrollWebView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mScrollConsumed = new int[2];
        this.mScrollOffset = new int[2];
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.mScroller = new OverScroller(this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public /* synthetic */ NestedScrollWebView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842885;
        }
        this(context, attributeSet, n);
    }

    public void dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable int[] offsetInWindow, int type, @NotNull int[] consumed) {
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type, consumed);
    }

    private final void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private final void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            VelocityTracker velocityTracker = this.mVelocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker);
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final void fling(int velocityY) {
        this.startNestedScroll(2, 1);
        this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0);
        this.mLastScrollerY = this.getScrollY();
        ViewCompat.postInvalidateOnAnimation((View)((View)this));
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            int dy = y - this.mLastScrollerY;
            if (dy != 0) {
                int scrollY = this.getScrollY();
                int dyUnConsumed = 0;
                int consumedY = dy;
                if (scrollY == 0) {
                    dyUnConsumed = dy;
                    consumedY = 0;
                } else if (scrollY + dy < 0) {
                    dyUnConsumed = dy + scrollY;
                    consumedY = -scrollY;
                }
                this.dispatchNestedScroll(0, consumedY, 0, dyUnConsumed, null, 1);
            }
            this.mLastScrollerY = y;
            ViewCompat.postInvalidateOnAnimation((View)((View)this));
        } else {
            if (this.hasNestedScrollingParent(1)) {
                this.stopNestedScroll(1);
            }
            this.mLastScrollerY = 0;
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.initVelocityTrackerIfNotExists();
        MotionEvent motion = MotionEvent.obtain((MotionEvent)event);
        switch (event.getAction()) {
            case 0: {
                this.mLastMotionY = (int)event.getRawY();
                this.startNestedScroll(2);
                VelocityTracker velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker);
                velocityTracker.addMovement(motion);
                this.mScroller.computeScrollOffset();
                if (this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
                break;
            }
            case 1: {
                VelocityTracker velocityTracker;
                VelocityTracker velocityTracker2 = velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker2);
                velocityTracker2.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.fling(-initialVelocity);
                }
                this.stopNestedScroll();
                this.recycleVelocityTracker();
                break;
            }
            case 3: {
                this.stopNestedScroll();
                this.recycleVelocityTracker();
                break;
            }
            case 2: {
                int y = (int)event.getRawY();
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    motion.offsetLocation(0.0f, (float)this.mScrollConsumed[1]);
                }
                this.mLastMotionY = y;
                int scrollY = this.getScrollY();
                int dyUnconsumed = 0;
                if (scrollY == 0) {
                    dyUnconsumed = deltaY;
                } else if (scrollY + deltaY < 0) {
                    dyUnconsumed = deltaY + scrollY;
                    motion.offsetLocation(0.0f, -((float)dyUnconsumed));
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                Intrinsics.checkNotNull((Object)velocityTracker);
                velocityTracker.addMovement(motion);
                boolean result = super.onTouchEvent(motion);
                this.dispatchNestedScroll(0, deltaY - dyUnconsumed, 0, dyUnconsumed, this.mScrollOffset);
                return result;
            }
        }
        return super.onTouchEvent(motion);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public boolean startNestedScroll(int axes, int type) {
        return this.mChildHelper.startNestedScroll(axes, type);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public void stopNestedScroll(int type) {
        this.mChildHelper.stopNestedScroll(type);
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean hasNestedScrollingParent(int type) {
        return this.mChildHelper.hasNestedScrollingParent(type);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, @Nullable int[] consumed, @Nullable int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, @Nullable int[] consumed, @Nullable int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, type);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    @JvmOverloads
    public NestedScrollWebView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public NestedScrollWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

