/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import com.flarelane.BaseErrorHandler;
import com.flarelane.HTTPClient;
import com.flarelane.Logger;
import com.flarelane.model.ModelInAppMessage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\t0\u000fH\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/flarelane/InAppService;", "", "()V", "isDisplaying", "", "()Z", "setDisplaying", "(Z)V", "getMessage", "", "projectId", "", "deviceId", "group", "callback", "Lkotlin/Function1;", "Lcom/flarelane/model/ModelInAppMessage;", "FlareLane_release"})
public final class InAppService {
    @NotNull
    public static final InAppService INSTANCE = new InAppService();
    private static boolean isDisplaying;

    private InAppService() {
    }

    public final boolean isDisplaying() {
        return isDisplaying;
    }

    public final void setDisplaying(boolean bl) {
        isDisplaying = bl;
    }

    @JvmStatic
    public static final void getMessage(@NotNull String projectId, @NotNull String deviceId, @NotNull String group, @NotNull Function1<? super ModelInAppMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (isDisplaying) {
            Logger.verbose("IAM is already displaying.");
            return;
        }
        isDisplaying = true;
        HTTPClient.post("internal/v1/projects/" + projectId + "/devices/" + deviceId + "/in-app-messages?group=" + group, null, new HTTPClient.ResponseHandler(callback){
            final /* synthetic */ Function1<ModelInAppMessage, Unit> $callback;
            {
                this.$callback = $callback;
            }

            protected void onSuccess(int responseCode, @NotNull JSONObject response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    InAppService.INSTANCE.setDisplaying(false);
                    JSONArray jsonArray = response.getJSONArray("data");
                    if (jsonArray.length() > 0) {
                        JSONObject jsonObject = jsonArray.getJSONObject(0);
                        String string = jsonObject.getString("id");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                        String string2 = jsonObject.getString("htmlString");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                        ModelInAppMessage model = new ModelInAppMessage(string, string2);
                        this.$callback.invoke((Object)model);
                    } else {
                        Logger.verbose("There is no displayable IAM");
                    }
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }
}

