/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.Device;
import com.flarelane.FlareLane;
import com.flarelane.HTTPClient;
import com.flarelane.Logger;
import com.flarelane.Utils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceService {
    DeviceService() {
    }

    static JSONObject getSystemInfo() throws Exception {
        JSONObject data = new JSONObject();
        data.put("platform", (Object)"android");
        data.put("deviceModel", (Object)Build.MODEL);
        data.put("osVersion", (Object)String.valueOf(Build.VERSION.RELEASE));
        data.put("sdkVersion", (Object)FlareLane.SdkInfo.version);
        data.put("timeZone", (Object)TimeZone.getDefault().getID());
        data.put("languageCode", (Object)Locale.getDefault().getLanguage());
        data.put("countryCode", (Object)Locale.getDefault().getCountry());
        data.put("sdkType", (Object)FlareLane.SdkInfo.type.toString());
        return data;
    }

    static void register(final Context context, final String projectId, final String pushToken) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String gaid = DeviceService.getAdvertisingId(context);
                    JSONObject data = DeviceService.getSystemInfo();
                    data.put("pushToken", (Object)pushToken);
                    data.put("isSubscribed", true);
                    data.put("gaid", (Object)gaid);
                    DeviceService.create(projectId, data, new ResponseHandler(){

                        @Override
                        public void onSuccess(Device device) {
                            BaseSharedPreferences.setDeviceId(context, device.id);
                            BaseSharedPreferences.setProjectId(context, projectId);
                            Logger.verbose("deviceId : " + device.id);
                        }
                    });
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    static void activate(Context context, final String projectId, final String deviceId, final String pushToken) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject data = DeviceService.getSystemInfo();
                    data.put("pushToken", (Object)pushToken);
                    data.put("lastActiveAt", (Object)Utils.getISO8601DateString());
                    DeviceService.update(projectId, deviceId, data, new ResponseHandler(){

                        @Override
                        public void onSuccess(Device device) {
                        }
                    });
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    static void deleteTags(String projectId, String deviceId, ArrayList<String> keys) throws JSONException {
        JSONObject data = new JSONObject();
        data.put("keys", (Object)new JSONArray(keys));
        HTTPClient.delete("internal/v1/projects/" + projectId + "/devices/" + deviceId + "/tags", data, new HTTPClient.ResponseHandler());
    }

    static void create(String projectId, JSONObject data, final ResponseHandler handler) {
        HTTPClient.post("internal/v1/projects/" + projectId + "/devices", data, new HTTPClient.ResponseHandler(){

            @Override
            void onSuccess(int responseCode, JSONObject response) {
                super.onSuccess(responseCode, response);
                try {
                    Device device = new Device(response.getJSONObject("data").getString("id"));
                    handler.onSuccess(device);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    static void update(String projectId, String deviceId, JSONObject data, final ResponseHandler handler) {
        HTTPClient.patch("internal/v1/projects/" + projectId + "/devices/" + deviceId, data, new HTTPClient.ResponseHandler(){

            @Override
            void onSuccess(int responseCode, JSONObject response) {
                super.onSuccess(responseCode, response);
                try {
                    Device device = new Device(response.getJSONObject("data").getString("id"));
                    handler.onSuccess(device);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    private static String getAdvertisingId(Context context) {
        try {
            AdvertisingIdClient.Info advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            if (!advertisingIdInfo.isLimitAdTrackingEnabled()) {
                String id = advertisingIdInfo.getId();
                return id;
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
        return null;
    }

    protected static interface ResponseHandler {
        public void onSuccess(Device var1);
    }
}

