/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.ChannelManager;
import com.flarelane.EventService;
import com.flarelane.FlareLane;
import com.flarelane.Logger;
import com.flarelane.Notification;
import com.flarelane.NotificationConvertedActivity;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class MessagingService
extends FirebaseMessagingService {
    private static boolean appInForeground(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            if (!runningAppProcess.processName.equals(context.getPackageName()) || runningAppProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public void onNewToken(String token) {
        Logger.verbose("onNewToken");
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            super.onMessageReceived(remoteMessage);
            if (remoteMessage == null) {
                return;
            }
            boolean isForeground = MessagingService.appInForeground(this.getApplicationContext());
            Logger.verbose("onMessageReceived isForeground: " + isForeground);
            if (remoteMessage.getData().size() > 0) {
                Logger.verbose("Message data payload: " + remoteMessage.getData());
                String isFlareLane = (String)remoteMessage.getData().get("isFlareLane");
                if (isFlareLane == null || !isFlareLane.contentEquals("true")) {
                    Logger.verbose("It is not a message of FlareLane");
                    return;
                }
                Notification flarelaneNotification = new Notification((String)remoteMessage.getData().get("notificationId"), (String)remoteMessage.getData().get("body"), (String)remoteMessage.getData().get("title"), (String)remoteMessage.getData().get("url"));
                String projectId = BaseSharedPreferences.getProjectId(this.getApplicationContext(), false);
                String deviceId = BaseSharedPreferences.getDeviceId(this.getApplicationContext(), false);
                if (isForeground) {
                    EventService.createForegroundReceived(projectId, deviceId, flarelaneNotification);
                } else {
                    EventService.createBackgroundReceived(projectId, deviceId, flarelaneNotification);
                }
                Intent intent = new Intent(this.getApplicationContext(), NotificationConvertedActivity.class).addFlags(0x24000000).putExtra("title", flarelaneNotification.title).putExtra("body", flarelaneNotification.body).putExtra("url", flarelaneNotification.url).putExtra("notificationId", flarelaneNotification.id);
                PendingIntent contentIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)new Random().nextInt(543254), (Intent)intent, (int)0x8000000);
                int currentIcon = this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)128).icon;
                Context context = this.getApplicationContext();
                android.app.Notification notification = new NotificationCompat.Builder(this.getApplicationContext(), ChannelManager.getChannelId(this.getApplicationContext())).setSmallIcon(this.getNotificationIcon()).setContentText((CharSequence)flarelaneNotification.body).setContentTitle((CharSequence)(flarelaneNotification.title == null ? context.getApplicationInfo().loadLabel(context.getPackageManager()).toString() : flarelaneNotification.title)).setAutoCancel(true).setContentIntent(contentIntent).setPriority(2).setVisibility(1).build();
                notification.defaults |= 1;
                notification.defaults |= 4;
                notification.defaults |= 2;
                NotificationManagerCompat.from((Context)this.getApplicationContext()).notify((int)new Date().getTime(), notification);
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    private int getNotificationIcon() {
        if (Build.VERSION.SDK_INT >= 21 && FlareLane.notificationIcon != 0) {
            return FlareLane.notificationIcon;
        }
        return 17301569;
    }
}

