/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import com.flarelane.FlareLane;
import com.flarelane.HTTPClient;
import com.flarelane.Notification;
import com.flarelane.Utils;
import org.json.JSONObject;

class EventService {
    static Notification unhandledConvertedNotification;

    EventService() {
    }

    protected static void createConverted(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "CONVERTED");
        if (FlareLane.notificationConvertedHandler != null) {
            FlareLane.notificationConvertedHandler.onConverted(notification);
        } else {
            unhandledConvertedNotification = notification;
        }
    }

    protected static void createBackgroundReceived(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "BACKGROUND_RECEIVED");
    }

    protected static void createForegroundReceived(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "FOREGROUND_RECEIVED");
    }

    private static void create(String projectId, String deviceId, String notificationId, String type) throws Exception {
        JSONObject body = new JSONObject();
        body.put("notificationId", (Object)notificationId);
        body.put("deviceId", (Object)deviceId);
        body.put("platform", (Object)"android");
        body.put("type", (Object)type);
        body.put("createdAt", (Object)Utils.getISO8601DateString());
        HTTPClient.post("internal/v1/projects/" + projectId + "/events", body, new HTTPClient.ResponseHandler());
    }
}

