/*
 * Decompiled with CFR 0.152.
 */
package com.github.flakm;

import com.github.flakm.ConfigEnricher$;
import com.github.flakm.InMemoryLdapServer;
import com.github.flakm.LdapContext;
import com.github.flakm.LdapContext$;
import com.github.flakm.SSLProvider;
import com.github.flakm.SSLProvider$NotSecure$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import java.net.InetAddress;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class InMemoryLdapServer$ {
    public static InMemoryLdapServer$ MODULE$;
    private final Null$ nil;
    private final Logger log;
    private volatile InMemoryLdapServer.ServerWithContext server;

    static {
        new InMemoryLdapServer$();
    }

    private Null$ nil() {
        return this.nil;
    }

    private Logger log() {
        return this.log;
    }

    public Config defaultConfig() {
        return ConfigEnricher$.MODULE$.enrichConfig(ConfigFactory.load());
    }

    private InMemoryLdapServer.ServerWithContext server() {
        return this.server;
    }

    private void server_$eq(InMemoryLdapServer.ServerWithContext x$1) {
        this.server = x$1;
    }

    private Tuple2<InMemoryDirectoryServerConfig, SSLProvider.SecurityContext> defaultSettings(Config config) {
        Tuple4 tuple4;
        InMemoryDirectoryServerConfig imdsc;
        block7: {
            Tuple4 tuple42;
            block4: {
                SSLContext s;
                SSLProvider.SecurityContext clientContext;
                block6: {
                    block5: {
                        imdsc = new InMemoryDirectoryServerConfig(new String[]{config.getString("inmemoryldap.baseDn")});
                        imdsc.addAdditionalBindCredentials(config.getString("inmemoryldap.admin.dn"), config.getString("inmemoryldap.admin.password"));
                        if (!config.getBoolean("inmemoryldap.ssl.enabled")) break block4;
                        SSLProvider sslProvider = new SSLProvider(config);
                        Tuple2 tuple2 = new Tuple2((Object)sslProvider.serverSSLContext(), (Object)sslProvider.clientSSLContext());
                        if (tuple2 == null) break block5;
                        SSLProvider.SecurityContext securityContext = (SSLProvider.SecurityContext)tuple2._1();
                        clientContext = (SSLProvider.SecurityContext)tuple2._2();
                        if (!(securityContext instanceof SSLProvider.Secured)) break block5;
                        SSLProvider.Secured secured = (SSLProvider.Secured)securityContext;
                        s = secured.sslContext();
                        if (clientContext instanceof SSLProvider.Secured) break block6;
                    }
                    throw new IllegalArgumentException("inmemoryldap.ssl.enabled set to true but stores are not configured correctly!");
                }
                SSLProvider.Secured secured = (SSLProvider.Secured)clientContext;
                SSLContext c = secured.sslContext();
                Tuple4 tuple43 = new Tuple4((Object)s.getServerSocketFactory(), (Object)c.getSocketFactory(), (Object)c.getSocketFactory(), (Object)secured);
                tuple42 = tuple43;
                break block7;
            }
            this.nil();
            this.nil();
            this.nil();
            tuple42 = tuple4 = new Tuple4(null, null, null, (Object)SSLProvider$NotSecure$.MODULE$);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        SSLServerSocketFactory serverSocketFactory = (SSLServerSocketFactory)tuple4._1();
        SSLSocketFactory clientSocketFactory = (SSLSocketFactory)tuple4._2();
        SSLSocketFactory startTLSSocketFactory = (SSLSocketFactory)tuple4._3();
        Product clientContext = (Product)tuple4._4();
        Tuple4 tuple44 = new Tuple4((Object)serverSocketFactory, (Object)clientSocketFactory, (Object)startTLSSocketFactory, (Object)clientContext);
        Tuple4 tuple45 = tuple44;
        SSLServerSocketFactory serverSocketFactory2 = (SSLServerSocketFactory)tuple45._1();
        SSLSocketFactory clientSocketFactory2 = (SSLSocketFactory)tuple45._2();
        SSLSocketFactory startTLSSocketFactory2 = (SSLSocketFactory)tuple45._3();
        Product clientContext2 = (Product)tuple45._4();
        InMemoryListenerConfig listenerConf = new InMemoryListenerConfig(config.getString("inmemoryldap.listenerName"), InetAddress.getByName(config.getString("inmemoryldap.listenAddress")), config.getInt("inmemoryldap.listenPort"), (ServerSocketFactory)serverSocketFactory2, (SocketFactory)clientSocketFactory2, startTLSSocketFactory2);
        imdsc.setListenerConfigs(new InMemoryListenerConfig[]{listenerConf});
        return new Tuple2((Object)imdsc, (Object)clientContext2);
    }

    public synchronized LdapContext start(Config config) {
        BoxedUnit boxedUnit;
        InMemoryLdapServer.ServerWithContext serverWithContext = this.server();
        this.nil();
        Object var2_2 = null;
        if (!(serverWithContext != null ? !((Object)serverWithContext).equals(var2_2) : var2_2 != null)) {
            this.server_$eq(this.startInternal(config));
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.log().underlying().isWarnEnabled()) {
            this.log().underlying().warn("Server already running");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return LdapContext$.MODULE$.apply(this.server().server(), this.server().secContext());
    }

    public Config start$default$1() {
        return this.defaultConfig();
    }

    private InMemoryLdapServer.ServerWithContext startInternal(Config config) {
        BoxedUnit boxedUnit;
        Tuple2<InMemoryDirectoryServerConfig, SSLProvider.SecurityContext> tuple2 = this.defaultSettings(config);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InMemoryDirectoryServerConfig settings = (InMemoryDirectoryServerConfig)tuple2._1();
        SSLProvider.SecurityContext sslContext = (SSLProvider.SecurityContext)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)settings, (Object)sslContext);
        Tuple2 tuple23 = tuple22;
        InMemoryDirectoryServerConfig settings2 = (InMemoryDirectoryServerConfig)tuple23._1();
        SSLProvider.SecurityContext sslContext2 = (SSLProvider.SecurityContext)tuple23._2();
        InMemoryDirectoryServer ds = new InMemoryDirectoryServer(settings2);
        config.getStringList("inmemoryldap.files").forEach(p -> {
            BoxedUnit boxedUnit;
            String path = MODULE$.getClass().getResource((String)p).getPath();
            if (MODULE$.log().underlying().isDebugEnabled()) {
                MODULE$.log().underlying().debug("Installing ldif file from {}", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ds.importFromLDIF(false, path);
        });
        ds.startListening();
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Running in memory ldap server on {}:{}", new Object[]{ds.getListenAddress(), BoxesRunTime.boxToInteger((int)ds.getListenPort())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new InMemoryLdapServer.ServerWithContext(ds, sslContext2);
    }

    private Config startInternal$default$1() {
        return ConfigFactory.defaultReference();
    }

    public synchronized void stop() {
        BoxedUnit boxedUnit;
        InMemoryLdapServer.ServerWithContext serverWithContext = this.server();
        this.nil();
        Object var1_1 = null;
        if (serverWithContext == null ? var1_1 != null : !((Object)serverWithContext).equals(var1_1)) {
            this.server().server().shutDown(true);
            this.nil();
            this.server_$eq(null);
        } else if (this.log().underlying().isWarnEnabled()) {
            this.log().underlying().warn("ldap server cannot be closed as it is not running");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T> T withRunningLdap(Function0<Function1<LdapContext, T>> body) {
        return this.withRunningLdapConfig(this.withRunningLdapConfig$default$1(), body);
    }

    public <T> T withRunningLdapConfig(Config config, Function0<Function1<LdapContext, T>> body) {
        BoxedUnit boxedUnit;
        Object object;
        InMemoryLdapServer.ServerWithContext internal = this.startInternal(config);
        LdapContext ctx = LdapContext$.MODULE$.apply(internal.server(), internal.secContext());
        try {
            object = ((Function1)body.apply()).apply((Object)ctx);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit2;
            ctx.shutDown();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("In memory ldap server closed");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        ctx.shutDown();
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("In memory ldap server closed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (T)object;
    }

    public <T> Config withRunningLdapConfig$default$1() {
        return this.defaultConfig();
    }

    private InMemoryLdapServer$() {
        MODULE$ = this;
        this.nil = null;
        this.log = Logger$.MODULE$.apply(this.getClass());
    }
}

