/*
 * Decompiled with CFR 0.152.
 */
package com.github.flakm;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class InMemoryLdapServer$ {
    public static InMemoryLdapServer$ MODULE$;
    private final Logger log;
    private volatile InMemoryDirectoryServer server;

    static {
        new InMemoryLdapServer$();
    }

    private Logger log() {
        return this.log;
    }

    /*
     * WARNING - void declaration
     */
    private InMemoryDirectoryServerConfig defaultSettings(Config config) {
        void var2_2;
        InMemoryDirectoryServerConfig imdsc = new InMemoryDirectoryServerConfig(new String[]{config.getString("inmemoryldap.baseDn")});
        imdsc.addAdditionalBindCredentials(config.getString("inmemoryldap.admin.dn"), config.getString("inmemoryldap.admin.password"));
        Object serverSocketFactory = null;
        InMemoryListenerConfig listenerConf = new InMemoryListenerConfig(config.getString("inmemoryldap.listenerName"), InetAddress.getByName(config.getString("inmemoryldap.listenAddress")), config.getInt("inmemoryldap.listenPort"), null, null, null);
        imdsc.setListenerConfigs(new InMemoryListenerConfig[]{listenerConf});
        return var2_2;
    }

    private InMemoryDirectoryServer server() {
        return this.server;
    }

    private void server_$eq(InMemoryDirectoryServer x$1) {
        this.server = x$1;
    }

    public synchronized InMemoryDirectoryServer start(Config config) {
        BoxedUnit boxedUnit;
        if (this.server() == null) {
            this.server_$eq(this.startInternal(config));
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.log().underlying().isWarnEnabled()) {
            this.log().underlying().warn("Server already running");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.server();
    }

    public Config start$default$1() {
        return ConfigFactory.defaultReference();
    }

    /*
     * WARNING - void declaration
     */
    private InMemoryDirectoryServer startInternal(Config config) {
        void var2_2;
        BoxedUnit boxedUnit;
        InMemoryDirectoryServer ds = new InMemoryDirectoryServer(this.defaultSettings(config));
        config.getStringList("inmemoryldap.files").forEach(p -> {
            BoxedUnit boxedUnit;
            String path = MODULE$.getClass().getResource((String)p).getPath();
            if (MODULE$.log().underlying().isDebugEnabled()) {
                MODULE$.log().underlying().debug("Installing ldif file from {}", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ds.importFromLDIF(false, path);
        });
        ds.startListening();
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Running in memory ldap server on {}:{}", new Object[]{ds.getListenAddress(), BoxesRunTime.boxToInteger((int)ds.getListenPort())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private Config startInternal$default$1() {
        return ConfigFactory.defaultReference();
    }

    public synchronized void stop() {
        BoxedUnit boxedUnit;
        if (this.server() != null) {
            this.server().shutDown(true);
            this.server_$eq(null);
        } else if (this.log().underlying().isWarnEnabled()) {
            this.log().underlying().warn("ldap server cannot be closed as it is not running");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T> T withRunningLdap(Function0<Function1<InMemoryDirectoryServer, T>> body) {
        return this.withRunningLdapConfig(this.withRunningLdapConfig$default$1(), body);
    }

    public <T> T withRunningLdapConfig(Config config, Function0<Function1<InMemoryDirectoryServer, T>> body) {
        BoxedUnit boxedUnit;
        Object object;
        InMemoryDirectoryServer ds = this.startInternal(config);
        try {
            object = ((Function1)body.apply()).apply((Object)ds);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit2;
            ds.shutDown(true);
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("In memory ldap server closed");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        ds.shutDown(true);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("In memory ldap server closed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (T)object;
    }

    public <T> Config withRunningLdapConfig$default$1() {
        return ConfigFactory.defaultReference();
    }

    private InMemoryLdapServer$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(this.getClass());
    }
}

