/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.info_providers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.fingerprintjs.android.fingerprint.info_providers.BatteryInfoProvider;
import com.fingerprintjs.android.fingerprint.tools.ExceptionSafeExecutorKt;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/fingerprintjs/android/fingerprint/info_providers/BatteryInfoProviderImpl;", "Lcom/fingerprintjs/android/fingerprint/info_providers/BatteryInfoProvider;", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "batteryHealth", "", "batteryHealthStringDescription", "", "batteryTotalCapacity", "fingerprint_release"})
public final class BatteryInfoProviderImpl
implements BatteryInfoProvider {
    @NotNull
    private final Context applicationContext;

    public BatteryInfoProviderImpl(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @Override
    @NotNull
    public String batteryHealth() {
        Intent intent = this.applicationContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (intent == null) {
            return "";
        }
        Intent intent2 = intent;
        int health = intent2.getIntExtra("health", -1);
        return health != -1 ? this.batteryHealthStringDescription(health) : "";
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    @NotNull
    public String batteryTotalCapacity() {
        return ExceptionSafeExecutorKt.executeSafe((Function0)new Function0<String>(this){
            final /* synthetic */ BatteryInfoProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Class[]{Context.class};
                Constructor<?> constructor = Class.forName("com.android.internal.os.PowerProfile").getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{BatteryInfoProviderImpl.access$getApplicationContext$p(this.this$0)};
                ? mPowerProfile = constructor.newInstance(objectArray);
                Object object = Class.forName("com.android.internal.os.PowerProfile").getMethod("getBatteryCapacity", new Class[0]).invoke(mPowerProfile, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                double batteryCapacity = (Double)object;
                return String.valueOf(batteryCapacity);
            }
        }, "");
    }

    private final String batteryHealthStringDescription(int batteryHealth2) {
        String string;
        switch (batteryHealth2) {
            case 2: {
                string = "good";
                break;
            }
            case 3: {
                string = "overheat";
                break;
            }
            case 7: {
                string = "cold";
                break;
            }
            case 4: {
                string = "dead";
                break;
            }
            case 5: {
                string = "over voltage";
                break;
            }
            case 6: {
                string = "unspecified failure";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(BatteryInfoProviderImpl $this) {
        return $this.applicationContext;
    }
}

