/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.signal_providers.device_state;

import com.fingerprintjs.android.fingerprint.info_providers.DevicePersonalizationInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.DeviceSecurityInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.FingerprintSensorInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.SettingsDataSource;
import com.fingerprintjs.android.fingerprint.signal_providers.IdentificationSignal;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.device_state.DeviceStateRawData;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00170\u0016H\u0002J\u0016\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00170\u0016H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/SignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateRawData;", "settingsDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/SettingsDataSource;", "devicePersonalizationInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/DevicePersonalizationInfoProvider;", "deviceSecurityInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/DeviceSecurityInfoProvider;", "fingerprintSensorInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/FingerprintSensorInfoProvider;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/info_providers/SettingsDataSource;Lcom/fingerprintjs/android/fingerprint/info_providers/DevicePersonalizationInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/DeviceSecurityInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/FingerprintSensorInfoProvider;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;I)V", "rawData", "fingerprint", "", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "v1", "", "Lcom/fingerprintjs/android/fingerprint/signal_providers/IdentificationSignal;", "", "v2", "fingerprint_release"})
public final class DeviceStateSignalGroupProvider
extends SignalGroupProvider<DeviceStateRawData> {
    @NotNull
    private final Hasher hasher;
    @NotNull
    private final DeviceStateRawData rawData;

    public DeviceStateSignalGroupProvider(@NotNull SettingsDataSource settingsDataSource, @NotNull DevicePersonalizationInfoProvider devicePersonalizationInfoProvider, @NotNull DeviceSecurityInfoProvider deviceSecurityInfoProvider, @NotNull FingerprintSensorInfoProvider fingerprintSensorInfoProvider, @NotNull Hasher hasher, int version) {
        Intrinsics.checkNotNullParameter((Object)settingsDataSource, (String)"settingsDataSource");
        Intrinsics.checkNotNullParameter((Object)devicePersonalizationInfoProvider, (String)"devicePersonalizationInfoProvider");
        Intrinsics.checkNotNullParameter((Object)deviceSecurityInfoProvider, (String)"deviceSecurityInfoProvider");
        Intrinsics.checkNotNullParameter((Object)fingerprintSensorInfoProvider, (String)"fingerprintSensorInfoProvider");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        super(version);
        this.hasher = hasher;
        this.rawData = new DeviceStateRawData(settingsDataSource.adbEnabled(), settingsDataSource.developmentSettingsEnabled(), settingsDataSource.httpProxy(), settingsDataSource.transitionAnimationScale(), settingsDataSource.windowAnimationScale(), settingsDataSource.dataRoamingEnabled(), settingsDataSource.accessibilityEnabled(), settingsDataSource.defaultInputMethod(), settingsDataSource.rttCallingMode(), settingsDataSource.touchExplorationEnabled(), settingsDataSource.alarmAlertPath(), settingsDataSource.dateFormat(), settingsDataSource.endButtonBehaviour(), settingsDataSource.fontScale(), settingsDataSource.screenOffTimeout(), settingsDataSource.textAutoReplaceEnable(), settingsDataSource.textAutoPunctuate(), settingsDataSource.time12Or24(), deviceSecurityInfoProvider.isPinSecurityEnabled(), fingerprintSensorInfoProvider.getStatus().getStringDescription(), devicePersonalizationInfoProvider.ringtoneSource(), ArraysKt.toList((Object[])devicePersonalizationInfoProvider.availableLocales()), devicePersonalizationInfoProvider.regionCountry(), devicePersonalizationInfoProvider.defaultLanguage(), devicePersonalizationInfoProvider.timezone());
    }

    @Override
    @NotNull
    public String fingerprint(@NotNull StabilityLevel stabilityLevel) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        int n = this.getVersion();
        switch (n) {
            case 1: {
                string = this.combineSignals(this.v1(), StabilityLevel.UNIQUE);
                break;
            }
            case 2: {
                string = this.combineSignals(this.v2(), stabilityLevel);
                break;
            }
            default: {
                string = this.combineSignals(this.v2(), stabilityLevel);
            }
        }
        return this.hasher.hash(string);
    }

    @Override
    @NotNull
    public DeviceStateRawData rawData() {
        return this.rawData;
    }

    private final List<IdentificationSignal<? extends Object>> v1() {
        Object[] objectArray = new IdentificationSignal[]{this.rawData.adbEnabled(), this.rawData.developmentSettingsEnabled(), this.rawData.httpProxy(), this.rawData.transitionAnimationScale(), this.rawData.windowAnimationScale(), this.rawData.dataRoamingEnabled(), this.rawData.accessibilityEnabled(), this.rawData.defaultInputMethod(), this.rawData.rttCallingMode(), this.rawData.touchExplorationEnabled(), this.rawData.alarmAlertPath(), this.rawData.dateFormat(), this.rawData.endButtonBehaviour(), this.rawData.fontScale(), this.rawData.screenOffTimeout(), this.rawData.textAutoReplaceEnable(), this.rawData.textAutoPunctuate(), this.rawData.time12Or24(), this.rawData.isPinSecurityEnabled(), this.rawData.fingerprintSensorStatus(), this.rawData.ringtoneSource(), this.rawData.availableLocales()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<IdentificationSignal<? extends Object>> v2() {
        Object[] objectArray = new IdentificationSignal[]{this.rawData.adbEnabled(), this.rawData.developmentSettingsEnabled(), this.rawData.httpProxy(), this.rawData.transitionAnimationScale(), this.rawData.windowAnimationScale(), this.rawData.dataRoamingEnabled(), this.rawData.accessibilityEnabled(), this.rawData.defaultInputMethod(), this.rawData.touchExplorationEnabled(), this.rawData.alarmAlertPath(), this.rawData.dateFormat(), this.rawData.endButtonBehaviour(), this.rawData.fontScale(), this.rawData.screenOffTimeout(), this.rawData.time12Or24(), this.rawData.isPinSecurityEnabled(), this.rawData.fingerprintSensorStatus(), this.rawData.ringtoneSource(), this.rawData.availableLocales(), this.rawData.regionCountry(), this.rawData.timezone(), this.rawData.defaultLanguage()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

