/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.hardware.SensorManager;
import android.hardware.input.InputManager;
import android.media.MediaCodecList;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import androidx.core.hardware.fingerprint.FingerprintManagerCompat;
import com.fingerprintjs.android.fingerprint.Configuration;
import com.fingerprintjs.android.fingerprint.Fingerprinter;
import com.fingerprintjs.android.fingerprint.FingerprinterImpl;
import com.fingerprintjs.android.fingerprint.device_id_providers.AndroidIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.GsfIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.MediaDrmIdProvider;
import com.fingerprintjs.android.fingerprint.info_providers.BatteryInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.CameraInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.CameraInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.CodecInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.CpuInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.DevicePersonalizationInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.DeviceSecurityInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.FingerprintSensorInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.GpuInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.InputDevicesDataSourceImpl;
import com.fingerprintjs.android.fingerprint.info_providers.MemInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.MemInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.OsBuildInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.info_providers.PackageManagerDataSourceImpl;
import com.fingerprintjs.android.fingerprint.info_providers.SensorDataSourceImpl;
import com.fingerprintjs.android.fingerprint.info_providers.SettingsDataSourceImpl;
import com.fingerprintjs.android.fingerprint.signal_providers.device_id.DeviceIdProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.device_state.DeviceStateSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.installed_apps.InstalledAppsSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.os_build.OsBuildSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import com.fingerprintjs.android.fingerprint.tools.hashers.MurMur3x64x128Hasher;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u00107\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u00108\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/fingerprintjs/android/fingerprint/FingerprinterFactory;", "", "()V", "configuration", "Lcom/fingerprintjs/android/fingerprint/Configuration;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "instance", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter;", "createAndroidIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/AndroidIdProvider;", "context", "Landroid/content/Context;", "createBatteryInfoDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/BatteryInfoProviderImpl;", "createCameraInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CameraInfoProvider;", "createCodecInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CodecInfoProviderImpl;", "createCpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CpuInfoProviderImpl;", "createDeviceIdProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;", "createDevicePersonalizationDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/DevicePersonalizationInfoProviderImpl;", "createDeviceSecurityProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/DeviceSecurityInfoProviderImpl;", "createDeviceStateSignalGroupProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;", "createFingerprintSensorStatusProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/FingerprintSensorInfoProviderImpl;", "createGpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/GpuInfoProviderImpl;", "createGsfIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/GsfIdProvider;", "createHardwareSignalGroupProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;", "createInputDevicesDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/InputDevicesDataSourceImpl;", "createInstalledApplicationsSignalGroupProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;", "createMediaDrmProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/MediaDrmIdProvider;", "createMemoryInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/MemInfoProvider;", "createOsBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/OsBuildInfoProviderImpl;", "createOsBuildInfoSignalGroupProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;", "createPackageManagerDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/PackageManagerDataSourceImpl;", "createSensorDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/SensorDataSourceImpl;", "createSettingsDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/SettingsDataSourceImpl;", "getInstance", "initializeFingerprinter", "fingerprint_release"})
public final class FingerprinterFactory {
    @NotNull
    public static final FingerprinterFactory INSTANCE = new FingerprinterFactory();
    @NotNull
    private static Configuration configuration = new Configuration(3, null, 2, null);
    @Nullable
    private static Fingerprinter instance;
    @NotNull
    private static Hasher hasher;

    private FingerprinterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Fingerprinter getInstance(@NotNull Context context, @NotNull Configuration configuration) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!Intrinsics.areEqual((Object)FingerprinterFactory.configuration, (Object)configuration)) {
            instance = null;
        }
        if (instance == null) {
            object = FingerprinterFactory.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                if (instance == null) {
                    instance = INSTANCE.initializeFingerprinter(context, configuration);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        object = instance;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final Fingerprinter initializeFingerprinter(Context context, Configuration configuration) {
        FingerprinterFactory.configuration = configuration;
        hasher = configuration.getHasher();
        return new FingerprinterImpl(this.createHardwareSignalGroupProvider(context), this.createOsBuildInfoSignalGroupProvider(context), this.createDeviceIdProvider(context), this.createInstalledApplicationsSignalGroupProvider(context), this.createDeviceStateSignalGroupProvider(context), configuration);
    }

    private final HardwareSignalGroupProvider createHardwareSignalGroupProvider(Context context) {
        return new HardwareSignalGroupProvider(this.createCpuInfoProvider(), this.createMemoryInfoProvider(context), this.createOsBuildInfoProvider(), this.createSensorDataSource(context), this.createInputDevicesDataSource(context), this.createBatteryInfoDataSource(context), this.createCameraInfoProvider(), this.createGpuInfoProvider(context), hasher, configuration.getVersion());
    }

    private final OsBuildSignalGroupProvider createOsBuildInfoSignalGroupProvider(Context context) {
        return new OsBuildSignalGroupProvider(this.createOsBuildInfoProvider(), this.createCodecInfoProvider(), this.createDeviceSecurityProvider(context), hasher, configuration.getVersion());
    }

    private final InstalledAppsSignalGroupProvider createInstalledApplicationsSignalGroupProvider(Context context) {
        return new InstalledAppsSignalGroupProvider(this.createPackageManagerDataSource(context), hasher, configuration.getVersion());
    }

    private final DeviceStateSignalGroupProvider createDeviceStateSignalGroupProvider(Context context) {
        return new DeviceStateSignalGroupProvider(this.createSettingsDataSource(context), this.createDevicePersonalizationDataSource(context), this.createDeviceSecurityProvider(context), this.createFingerprintSensorStatusProvider(context), hasher, configuration.getVersion());
    }

    private final DeviceIdProvider createDeviceIdProvider(Context context) {
        return new DeviceIdProvider(this.createGsfIdProvider(context), this.createAndroidIdProvider(context), this.createMediaDrmProvider(), configuration.getVersion());
    }

    private final CpuInfoProviderImpl createCpuInfoProvider() {
        return new CpuInfoProviderImpl();
    }

    private final MemInfoProvider createMemoryInfoProvider(Context context) {
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        String internalStorageDir = Environment.getRootDirectory().getAbsolutePath();
        StatFs internalStorageStatFs = new StatFs(internalStorageDir);
        File file = context.getExternalFilesDir(null);
        String externalStorageDir = file == null ? null : file.getAbsolutePath();
        StatFs externalStorageStatFs = externalStorageDir != null ? new StatFs(externalStorageDir) : null;
        return new MemInfoProviderImpl(activityManager, internalStorageStatFs, externalStorageStatFs);
    }

    private final OsBuildInfoProviderImpl createOsBuildInfoProvider() {
        return new OsBuildInfoProviderImpl();
    }

    private final GsfIdProvider createGsfIdProvider(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkNotNull((Object)contentResolver);
        return new GsfIdProvider(contentResolver);
    }

    private final MediaDrmIdProvider createMediaDrmProvider() {
        return new MediaDrmIdProvider();
    }

    private final AndroidIdProvider createAndroidIdProvider(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkNotNull((Object)contentResolver);
        return new AndroidIdProvider(contentResolver);
    }

    private final SensorDataSourceImpl createSensorDataSource(Context context) {
        Object object = context.getSystemService("sensor");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        return new SensorDataSourceImpl((SensorManager)object);
    }

    private final InputDevicesDataSourceImpl createInputDevicesDataSource(Context context) {
        Object object = context.getSystemService("input");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.input.InputManager");
        }
        return new InputDevicesDataSourceImpl((InputManager)object);
    }

    private final PackageManagerDataSourceImpl createPackageManagerDataSource(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        return new PackageManagerDataSourceImpl(packageManager);
    }

    private final SettingsDataSourceImpl createSettingsDataSource(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"context.contentResolver");
        return new SettingsDataSourceImpl(contentResolver);
    }

    private final DevicePersonalizationInfoProviderImpl createDevicePersonalizationDataSource(Context context) {
        RingtoneManager ringtoneManager = new RingtoneManager(context);
        AssetManager assetManager = context.getAssets();
        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"context.assets");
        AssetManager assetManager2 = assetManager;
        assetManager = context.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"context.resources.configuration");
        return new DevicePersonalizationInfoProviderImpl(ringtoneManager, assetManager2, (android.content.res.Configuration)assetManager);
    }

    private final FingerprintSensorInfoProviderImpl createFingerprintSensorStatusProvider(Context context) {
        FingerprintManagerCompat fingerprintManagerCompat = FingerprintManagerCompat.from((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)fingerprintManagerCompat, (String)"from(context)");
        return new FingerprintSensorInfoProviderImpl(fingerprintManagerCompat);
    }

    private final DeviceSecurityInfoProviderImpl createDeviceSecurityProvider(Context context) {
        Object object = context.getSystemService("device_policy");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.admin.DevicePolicyManager");
        }
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)object;
        object = context.getSystemService("keyguard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        return new DeviceSecurityInfoProviderImpl(devicePolicyManager, (KeyguardManager)object);
    }

    private final CodecInfoProviderImpl createCodecInfoProvider() {
        return Build.VERSION.SDK_INT >= 21 ? new CodecInfoProviderImpl(new MediaCodecList(1)) : (CodecInfoProviderImpl)null;
    }

    private final BatteryInfoProviderImpl createBatteryInfoDataSource(Context context) {
        return new BatteryInfoProviderImpl(context);
    }

    private final CameraInfoProvider createCameraInfoProvider() {
        return new CameraInfoProviderImpl();
    }

    private final GpuInfoProviderImpl createGpuInfoProvider(Context context) {
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        return new GpuInfoProviderImpl((ActivityManager)object);
    }

    static {
        hasher = new MurMur3x64x128Hasher();
    }
}

