/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.signal_providers.os_build;

import com.fingerprintjs.android.fingerprint.info_providers.CodecInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.DeviceSecurityInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.MediaCodecInfo;
import com.fingerprintjs.android.fingerprint.info_providers.OsBuildInfoProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.Signal;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.os_build.OsBuildRawData;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00150\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/SignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildRawData;", "osBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/OsBuildInfoProvider;", "codecInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CodecInfoProvider;", "deviceSecurityInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/DeviceSecurityInfoProvider;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/info_providers/OsBuildInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/CodecInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/DeviceSecurityInfoProvider;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;I)V", "rawData", "fingerprint", "", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "v1", "", "Lcom/fingerprintjs/android/fingerprint/signal_providers/Signal;", "v2", "", "fingerprint_release"})
public final class OsBuildSignalGroupProvider
extends SignalGroupProvider<OsBuildRawData> {
    private final OsBuildRawData rawData;
    private final Hasher hasher;

    @Override
    @NotNull
    public String fingerprint(@NotNull StabilityLevel stabilityLevel) {
        List<Signal<Object>> list;
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        switch (this.getVersion()) {
            case 1: {
                list = this.v1();
                break;
            }
            case 2: {
                list = this.v2();
                break;
            }
            default: {
                list = this.v2();
            }
        }
        return this.hasher.hash(this.combineSignals(list, stabilityLevel));
    }

    @Override
    @NotNull
    public OsBuildRawData rawData() {
        return this.rawData;
    }

    private final List<Signal<String>> v1() {
        return CollectionsKt.listOf(this.rawData.fingerprint());
    }

    private final List<Signal<? extends Object>> v2() {
        return CollectionsKt.listOf((Object[])new Signal[]{this.rawData.androidVersion(), this.rawData.sdkVersion(), this.rawData.kernelVersion(), this.rawData().encryptionStatus(), this.rawData().securityProviders(), this.rawData().codecList()});
    }

    public OsBuildSignalGroupProvider(@NotNull OsBuildInfoProvider osBuildInfoProvider, @Nullable CodecInfoProvider codecInfoProvider, @NotNull DeviceSecurityInfoProvider deviceSecurityInfoProvider, @NotNull Hasher hasher, int version) {
        Intrinsics.checkNotNullParameter((Object)osBuildInfoProvider, (String)"osBuildInfoProvider");
        Intrinsics.checkNotNullParameter((Object)deviceSecurityInfoProvider, (String)"deviceSecurityInfoProvider");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        super(version);
        this.hasher = hasher;
        String string = osBuildInfoProvider.fingerprint();
        String string2 = osBuildInfoProvider.androidVersion();
        String string3 = osBuildInfoProvider.sdkVersion();
        String string4 = osBuildInfoProvider.kernelVersion();
        Object object = codecInfoProvider;
        if (object == null || (object = object.codecsList()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.rawData = new OsBuildRawData(string, string2, string3, string4, (List<MediaCodecInfo>)object, deviceSecurityInfoProvider.encryptionStatus(), deviceSecurityInfoProvider.securityProvidersData());
    }
}

