/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.signal_providers.hardware;

import com.fingerprintjs.android.fingerprint.info_providers.BatteryInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.CameraInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.CpuInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.GpuInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.InputDeviceDataSource;
import com.fingerprintjs.android.fingerprint.info_providers.MemInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.OsBuildInfoProvider;
import com.fingerprintjs.android.fingerprint.info_providers.SensorDataSource;
import com.fingerprintjs.android.fingerprint.signal_providers.Signal;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareFingerprintRawData;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u0018\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u001eH\u0002J\u0016\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u001eH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/SignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareFingerprintRawData;", "cpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CpuInfoProvider;", "memInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/MemInfoProvider;", "osBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/OsBuildInfoProvider;", "sensorsDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/SensorDataSource;", "inputDeviceDataSource", "Lcom/fingerprintjs/android/fingerprint/info_providers/InputDeviceDataSource;", "batteryInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/BatteryInfoProvider;", "cameraInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/CameraInfoProvider;", "gpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/info_providers/GpuInfoProvider;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/info_providers/CpuInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/MemInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/OsBuildInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/SensorDataSource;Lcom/fingerprintjs/android/fingerprint/info_providers/InputDeviceDataSource;Lcom/fingerprintjs/android/fingerprint/info_providers/BatteryInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/CameraInfoProvider;Lcom/fingerprintjs/android/fingerprint/info_providers/GpuInfoProvider;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;I)V", "rawData", "fingerprint", "", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "v1", "", "Lcom/fingerprintjs/android/fingerprint/signal_providers/Signal;", "", "v2", "fingerprint_release"})
public final class HardwareSignalGroupProvider
extends SignalGroupProvider<HardwareFingerprintRawData> {
    private final HardwareFingerprintRawData rawData;
    private final Hasher hasher;

    @Override
    @NotNull
    public String fingerprint(@NotNull StabilityLevel stabilityLevel) {
        List<Signal<? extends Object>> list;
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        switch (this.getVersion()) {
            case 1: {
                list = this.v1();
                break;
            }
            case 2: {
                list = this.v2();
                break;
            }
            default: {
                list = this.v2();
            }
        }
        return this.hasher.hash(this.combineSignals(list, stabilityLevel));
    }

    private final List<Signal<? extends Object>> v1() {
        return CollectionsKt.listOf((Object[])new Signal[]{this.rawData.manufacturerName(), this.rawData.modelName(), this.rawData.totalRAM(), this.rawData.totalInternalStorageSpace(), this.rawData.procCpuInfo(), this.rawData.sensors(), this.rawData.inputDevices()});
    }

    private final List<Signal<? extends Object>> v2() {
        return CollectionsKt.listOf((Object[])new Signal[]{this.rawData.manufacturerName(), this.rawData.modelName(), this.rawData.totalRAM(), this.rawData.totalInternalStorageSpace(), this.rawData.procCpuInfo(), this.rawData.sensors(), this.rawData.inputDevices(), this.rawData.batteryFullCapacity(), this.rawData.batteryHealth(), this.rawData.glesVersion(), this.rawData.abiType(), this.rawData.coresCount(), this.rawData.cameraList()});
    }

    @Override
    @NotNull
    public HardwareFingerprintRawData rawData() {
        return this.rawData;
    }

    public HardwareSignalGroupProvider(@NotNull CpuInfoProvider cpuInfoProvider, @NotNull MemInfoProvider memInfoProvider, @NotNull OsBuildInfoProvider osBuildInfoProvider, @NotNull SensorDataSource sensorsDataSource, @NotNull InputDeviceDataSource inputDeviceDataSource, @NotNull BatteryInfoProvider batteryInfoProvider, @NotNull CameraInfoProvider cameraInfoProvider, @NotNull GpuInfoProvider gpuInfoProvider, @NotNull Hasher hasher, int version) {
        Intrinsics.checkNotNullParameter((Object)cpuInfoProvider, (String)"cpuInfoProvider");
        Intrinsics.checkNotNullParameter((Object)memInfoProvider, (String)"memInfoProvider");
        Intrinsics.checkNotNullParameter((Object)osBuildInfoProvider, (String)"osBuildInfoProvider");
        Intrinsics.checkNotNullParameter((Object)sensorsDataSource, (String)"sensorsDataSource");
        Intrinsics.checkNotNullParameter((Object)inputDeviceDataSource, (String)"inputDeviceDataSource");
        Intrinsics.checkNotNullParameter((Object)batteryInfoProvider, (String)"batteryInfoProvider");
        Intrinsics.checkNotNullParameter((Object)cameraInfoProvider, (String)"cameraInfoProvider");
        Intrinsics.checkNotNullParameter((Object)gpuInfoProvider, (String)"gpuInfoProvider");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        super(version);
        this.hasher = hasher;
        this.rawData = new HardwareFingerprintRawData(osBuildInfoProvider.manufacturerName(), osBuildInfoProvider.modelName(), memInfoProvider.totalRAM(), memInfoProvider.totalInternalStorageSpace(), cpuInfoProvider.cpuInfo(), sensorsDataSource.sensors(), inputDeviceDataSource.getInputDeviceData(), batteryInfoProvider.batteryHealth(), batteryInfoProvider.batteryTotalCapacity(), cameraInfoProvider.getCameraInfo(), gpuInfoProvider.glesVersion(), cpuInfoProvider.abiType(), cpuInfoProvider.coresCount());
    }
}

