/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.fingerprinters.os_build_fingerprint;

import com.fingerprintjs.android.fingerprint.datasources.OsBuildInfoProvider;
import com.fingerprintjs.android.fingerprint.fingerprinters.BaseFingerprinter;
import com.fingerprintjs.android.fingerprint.fingerprinters.os_build_fingerprint.OsBuildRawData;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fingerprintjs/android/fingerprint/fingerprinters/os_build_fingerprint/OsBuildFingerprinter;", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/BaseFingerprinter;", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/os_build_fingerprint/OsBuildRawData;", "osBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/OsBuildInfoProvider;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/datasources/OsBuildInfoProvider;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;I)V", "rawData", "calculate", "", "v1", "fingerprint_release"})
public final class OsBuildFingerprinter
extends BaseFingerprinter<OsBuildRawData> {
    private final OsBuildRawData rawData;
    private final OsBuildInfoProvider osBuildInfoProvider;
    private final Hasher hasher;

    @Override
    @NotNull
    public String calculate() {
        String string;
        switch (this.getVersion()) {
            case 1: {
                string = this.v1();
                break;
            }
            default: {
                string = this.v1();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public OsBuildRawData rawData() {
        return this.rawData;
    }

    private final String v1() {
        StringBuilder osBuildInfoSB = new StringBuilder();
        osBuildInfoSB.append(this.rawData.getFingerprint());
        String string = osBuildInfoSB.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"osBuildInfoSB.toString()");
        return this.hasher.hash(string);
    }

    public OsBuildFingerprinter(@NotNull OsBuildInfoProvider osBuildInfoProvider, @NotNull Hasher hasher, int version) {
        Intrinsics.checkParameterIsNotNull((Object)osBuildInfoProvider, (String)"osBuildInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)hasher, (String)"hasher");
        super(version);
        this.osBuildInfoProvider = osBuildInfoProvider;
        this.hasher = hasher;
        this.rawData = new OsBuildRawData(this.osBuildInfoProvider.fingerprint());
    }
}

