/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint;

import com.fingerprintjs.android.fingerprint.Fingerprinter;
import com.fingerprintjs.android.fingerprint.Type;
import com.fingerprintjs.android.fingerprint.device_id_providers.DeviceIdProvider;
import com.fingerprintjs.android.fingerprint.fingerprinters.BaseFingerprinter;
import com.fingerprintjs.android.fingerprint.fingerprinters.device_state.DeviceStateFingerprinter;
import com.fingerprintjs.android.fingerprint.fingerprinters.hardware.HardwareFingerprinter;
import com.fingerprintjs.android.fingerprint.fingerprinters.installed_apps.InstalledAppsFingerprinter;
import com.fingerprintjs.android.fingerprint.fingerprinters.os_build_fingerprint.OsBuildFingerprinter;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/fingerprintjs/android/fingerprint/FingerprinterImpl;", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter;", "hardwareFingerprinter", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/hardware/HardwareFingerprinter;", "osBuildFingerprinter", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/os_build_fingerprint/OsBuildFingerprinter;", "deviceIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/DeviceIdProvider;", "installedAppsFingerprinter", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/installed_apps/InstalledAppsFingerprinter;", "deviceStateFingerprinter", "Lcom/fingerprintjs/android/fingerprint/fingerprinters/device_state/DeviceStateFingerprinter;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "(Lcom/fingerprintjs/android/fingerprint/fingerprinters/hardware/HardwareFingerprinter;Lcom/fingerprintjs/android/fingerprint/fingerprinters/os_build_fingerprint/OsBuildFingerprinter;Lcom/fingerprintjs/android/fingerprint/device_id_providers/DeviceIdProvider;Lcom/fingerprintjs/android/fingerprint/fingerprinters/installed_apps/InstalledAppsFingerprinter;Lcom/fingerprintjs/android/fingerprint/fingerprinters/device_state/DeviceStateFingerprinter;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;)V", "deviceId", "", "fingerprint", "mask", "", "fingerprint_release"})
public final class FingerprinterImpl
implements Fingerprinter {
    private final HardwareFingerprinter hardwareFingerprinter;
    private final OsBuildFingerprinter osBuildFingerprinter;
    private final DeviceIdProvider deviceIdProvider;
    private final InstalledAppsFingerprinter installedAppsFingerprinter;
    private final DeviceStateFingerprinter deviceStateFingerprinter;
    private final Hasher hasher;

    @Override
    @NotNull
    public String deviceId() {
        return this.deviceIdProvider.getDeviceId();
    }

    @Override
    @NotNull
    public String fingerprint() {
        return this.fingerprint(Type.HARDWARE | Type.OS_BUILD | Type.DEVICE_STATE);
    }

    @Override
    @NotNull
    public String fingerprint(int mask) {
        StringBuilder fingerprintSb = new StringBuilder();
        LinkedList<BaseFingerprinter> fingerprinters = new LinkedList<BaseFingerprinter>();
        if ((mask & Type.HARDWARE) != 0) {
            fingerprinters.add(this.hardwareFingerprinter);
        }
        if ((mask & Type.OS_BUILD) != 0) {
            fingerprinters.add(this.osBuildFingerprinter);
        }
        if ((mask & Type.DEVICE_STATE) != 0) {
            fingerprinters.add(this.deviceStateFingerprinter);
        }
        if ((mask & Type.INSTALLED_APPS) != 0) {
            fingerprinters.add(this.installedAppsFingerprinter);
        }
        Iterable $this$forEach$iv = fingerprinters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseFingerprinter it = (BaseFingerprinter)element$iv;
            boolean bl = false;
            fingerprintSb.append(it.calculate());
        }
        String string = fingerprintSb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fingerprintSb.toString()");
        return this.hasher.hash(string);
    }

    @Override
    @NotNull
    public DeviceIdProvider deviceIdProvider() {
        return this.deviceIdProvider;
    }

    @Override
    @NotNull
    public HardwareFingerprinter hardwareFingerprinter() {
        return this.hardwareFingerprinter;
    }

    @Override
    @NotNull
    public OsBuildFingerprinter osBuildFingerprinter() {
        return this.osBuildFingerprinter;
    }

    @Override
    @NotNull
    public InstalledAppsFingerprinter installedAppsFingerprinter() {
        return this.installedAppsFingerprinter;
    }

    @Override
    @NotNull
    public DeviceStateFingerprinter deviceStateFingerprinter() {
        return this.deviceStateFingerprinter;
    }

    public FingerprinterImpl(@NotNull HardwareFingerprinter hardwareFingerprinter, @NotNull OsBuildFingerprinter osBuildFingerprinter, @NotNull DeviceIdProvider deviceIdProvider, @NotNull InstalledAppsFingerprinter installedAppsFingerprinter, @NotNull DeviceStateFingerprinter deviceStateFingerprinter, @NotNull Hasher hasher) {
        Intrinsics.checkParameterIsNotNull((Object)hardwareFingerprinter, (String)"hardwareFingerprinter");
        Intrinsics.checkParameterIsNotNull((Object)osBuildFingerprinter, (String)"osBuildFingerprinter");
        Intrinsics.checkParameterIsNotNull((Object)deviceIdProvider, (String)"deviceIdProvider");
        Intrinsics.checkParameterIsNotNull((Object)installedAppsFingerprinter, (String)"installedAppsFingerprinter");
        Intrinsics.checkParameterIsNotNull((Object)deviceStateFingerprinter, (String)"deviceStateFingerprinter");
        Intrinsics.checkParameterIsNotNull((Object)hasher, (String)"hasher");
        this.hardwareFingerprinter = hardwareFingerprinter;
        this.osBuildFingerprinter = osBuildFingerprinter;
        this.deviceIdProvider = deviceIdProvider;
        this.installedAppsFingerprinter = installedAppsFingerprinter;
        this.deviceStateFingerprinter = deviceStateFingerprinter;
        this.hasher = hasher;
    }
}

