/*
 * Decompiled with CFR 0.152.
 */
package com.zeugmasolutions.localehelper;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import com.zeugmasolutions.localehelper.LocaleHelperExtensionsKt;
import com.zeugmasolutions.localehelper.Locales;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/zeugmasolutions/localehelper/LocaleHelper;", "", "()V", "SELECTED_COUNTRY", "", "SELECTED_LANGUAGE", "initialized", "", "getLocale", "Ljava/util/Locale;", "context", "Landroid/content/Context;", "getPreferences", "Landroid/content/SharedPreferences;", "isRTL", "locale", "load", "onAttach", "persist", "", "setLocale", "updateContextResources", "localehelper_release"})
public final class LocaleHelper {
    private static final String SELECTED_LANGUAGE = "Locale.Helper.Selected.Language";
    private static final String SELECTED_COUNTRY = "Locale.Helper.Selected.Country";
    private static boolean initialized;
    public static final LocaleHelper INSTANCE;

    @NotNull
    public final Context onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!initialized) {
            Locale.setDefault(this.load(context));
            initialized = true;
        }
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        return this.updateContextResources(context, locale);
    }

    @NotNull
    public final Locale getLocale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.load(context);
    }

    @NotNull
    public final Context setLocale(@NotNull Context context, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.persist(context, locale);
        Locale.setDefault(locale);
        return this.updateContextResources(context, locale);
    }

    public final boolean isRTL(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Locales.INSTANCE.getRTL().contains(locale.getLanguage());
    }

    private final SharedPreferences getPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(LocaleHelper.class.getName(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026me, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    private final void persist(Context context, Locale locale) {
        if (locale == null) {
            return;
        }
        this.getPreferences(context).edit().putString(SELECTED_LANGUAGE, locale.getLanguage()).putString(SELECTED_COUNTRY, locale.getCountry()).apply();
    }

    private final Locale load(Context context) {
        Locale locale;
        SharedPreferences preferences = this.getPreferences(context);
        Locale locale2 = locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"default");
        String string = preferences.getString(SELECTED_LANGUAGE, locale2.getLanguage());
        if (string == null) {
            return locale;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"preferences.getString(SE\u2026nguage) ?: return default");
        String language = string;
        String string2 = preferences.getString(SELECTED_COUNTRY, locale.getCountry());
        if (string2 == null) {
            return locale;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"preferences.getString(SE\u2026ountry) ?: return default");
        String country = string2;
        return new Locale(language, country);
    }

    private final Context updateContextResources(Context context, Locale locale) {
        Context context2;
        Configuration configuration;
        Resources resources;
        if (Intrinsics.areEqual((Object)LocaleHelperExtensionsKt.getCurrentLocale(context), (Object)locale) && context instanceof Application) {
            return context;
        }
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
        Configuration configuration2 = configuration = resources2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
        LocaleHelperExtensionsKt.setCurrentLocale(configuration2, locale);
        if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLayoutDirection(locale);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Context context3 = context.createConfigurationContext(configuration);
            context2 = context3;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context.createConfigurationContext(configuration)");
        } else {
            resources.updateConfiguration(configuration, resources.getDisplayMetrics());
            context2 = context;
        }
        return context2;
    }

    private LocaleHelper() {
    }

    static {
        LocaleHelper localeHelper;
        INSTANCE = localeHelper = new LocaleHelper();
    }
}

