/*
 * Decompiled with CFR 0.152.
 */
package com.bambulabs.fdpulltorefresh;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.bambulabs.fdpulltorefresh.IGRefreshLayout;
import com.bambulabs.fdpulltorefresh.R;
import com.bambulabs.fdpulltorefresh.progress_bar.BaseProgressBar;
import com.bambulabs.fdpulltorefresh.progress_bar.CircleProgressBar;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\b*\u0003\u001c\u001f7\u0018\u00002\u00020\u0001:\u0001eB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020<H\u0002J\b\u0010>\u001a\u00020\u0018H\u0002J\u000e\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007J\b\u0010A\u001a\u00020<H\u0002J\u0018\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0007H\u0002J\u0006\u0010F\u001a\u00020\u0007J\u0010\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020\nH\u0002J\u0012\u0010I\u001a\u00020\u00182\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J0\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u0007H\u0014J\u0018\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u0007H\u0014J\u0010\u0010S\u001a\u00020<2\u0006\u0010C\u001a\u00020DH\u0002J\u0012\u0010T\u001a\u00020\u00182\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u000e\u0010U\u001a\u00020<2\u0006\u0010V\u001a\u00020\"J\u001e\u0010W\u001a\u00020<2\u0006\u0010X\u001a\u00020\u00152\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007J\b\u0010[\u001a\u00020<H\u0002J\u0014\u0010\\\u001a\u00020<2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020<0^J\u000e\u0010\\\u001a\u00020<2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010_\u001a\u00020<2\u0006\u0010`\u001a\u00020\u0018J\u0018\u0010_\u001a\u00020<2\u0006\u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020\u0018H\u0002J\u0010\u0010b\u001a\u00020<2\u0006\u0010c\u001a\u00020\u0007H\u0002J\u0012\u0010d\u001a\u00020<2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00108R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DECELERATE_INTERPOLATION_FACTOR", "", "DRAG_MAX_DISTANCE", "getDRAG_MAX_DISTANCE", "()I", "setDRAG_MAX_DISTANCE", "(I)V", "DRAG_RATE", "MAX_OFFSET_ANIMATION_DURATION", "callback", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout$InstaRefreshCallback;", "customView", "Landroid/view/View;", "customViewHeight", "customViewSet", "", "customViewWidth", "mActivePointerId", "mAnimateToCorrectPosition", "com/bambulabs/fdpulltorefresh/IGRefreshLayout$mAnimateToCorrectPosition$1", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout$mAnimateToCorrectPosition$1;", "mAnimateToStartPosition", "com/bambulabs/fdpulltorefresh/IGRefreshLayout$mAnimateToStartPosition$1", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout$mAnimateToStartPosition$1;", "mBar", "Lcom/bambulabs/fdpulltorefresh/progress_bar/BaseProgressBar;", "mCurrentDragPercent", "mCurrentOffsetTop", "mDecelerateInterpolator", "Landroid/view/animation/Interpolator;", "getMDecelerateInterpolator", "()Landroid/view/animation/Interpolator;", "setMDecelerateInterpolator", "(Landroid/view/animation/Interpolator;)V", "mFrom", "mFromDragPercent", "mInitialMotionY", "mIsBeingDragged", "mNotify", "mRefreshing", "mTarget", "mTargetPaddingBottom", "mTargetPaddingLeft", "mTargetPaddingRight", "mTargetPaddingTop", "mToStartListener", "com/bambulabs/fdpulltorefresh/IGRefreshLayout$mToStartListener$1", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout$mToStartListener$1;", "mTotalDragDistance", "mTouchSlop", "animateOffsetToCorrectPosition", "", "animateOffsetToStartPosition", "canChildScrollUp", "dp2px", "dp", "ensureTarget", "getMotionEventY", "ev", "Landroid/view/MotionEvent;", "activePointerId", "getTotalDragDistance", "moveToStart", "interpolatedTime", "onInterceptTouchEvent", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSecondaryPointerUp", "onTouchEvent", "setCustomBar", "bar", "setCustomView", "view", "height", "width", "setDefaultBar", "setRefreshListener", "action", "Lkotlin/Function0;", "setRefreshing", "refreshing", "notify", "setTargetOffsetTop", "offset", "setupAttributes", "InstaRefreshCallback", "fdpulltorefresh_release"})
public final class IGRefreshLayout
extends ViewGroup {
    private final float DRAG_RATE = 0.5f;
    private int DRAG_MAX_DISTANCE;
    private final int MAX_OFFSET_ANIMATION_DURATION = 700;
    private final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    @Nullable
    private Interpolator mDecelerateInterpolator;
    private View mTarget;
    private int mTargetPaddingTop;
    private int mTargetPaddingBottom;
    private int mTargetPaddingRight;
    private int mTargetPaddingLeft;
    private boolean mRefreshing;
    private boolean mNotify;
    private int mCurrentOffsetTop;
    private int mActivePointerId;
    private boolean mIsBeingDragged;
    private int mTouchSlop;
    private float mCurrentDragPercent;
    private int mTotalDragDistance;
    private int mInitialMotionY;
    private int mFrom;
    private float mFromDragPercent;
    private BaseProgressBar mBar;
    private InstaRefreshCallback callback;
    private boolean customViewSet;
    private View customView;
    private int customViewHeight;
    private int customViewWidth;
    private final mAnimateToStartPosition.1 mAnimateToStartPosition;
    private final mAnimateToCorrectPosition.1 mAnimateToCorrectPosition;
    private final mToStartListener.1 mToStartListener;
    private HashMap _$_findViewCache;

    public final int getDRAG_MAX_DISTANCE() {
        return this.DRAG_MAX_DISTANCE;
    }

    public final void setDRAG_MAX_DISTANCE(int n) {
        this.DRAG_MAX_DISTANCE = n;
    }

    @Nullable
    public final Interpolator getMDecelerateInterpolator() {
        return this.mDecelerateInterpolator;
    }

    public final void setMDecelerateInterpolator(@Nullable Interpolator interpolator) {
        this.mDecelerateInterpolator = interpolator;
    }

    private final void setupAttributes(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IGRefreshLayout, 0, 0);
        this.DRAG_MAX_DISTANCE = typedArray.getInt(R.styleable.IGRefreshLayout_offsetTop, 120);
        if (!typedArray.getBoolean(R.styleable.IGRefreshLayout_customBar, false)) {
            this.setDefaultBar();
            this.customViewSet = true;
        }
    }

    private final void setDefaultBar() {
        this.mBar.setParent(this);
        this.addView(this.mBar);
    }

    public final void setCustomBar(@NotNull BaseProgressBar bar) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)bar), (String)"bar");
        if (this.customViewSet) {
            throw (Throwable)new Exception("ViewGroup can contain only one customBar");
        }
        this.customViewSet = true;
        this.mBar = bar;
        this.mBar.setParent(this);
        this.addView(this.mBar, 0);
    }

    public final void setCustomView(@NotNull View view, int height, int width) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.customView = view;
        this.customViewHeight = height;
        this.customViewWidth = width;
        this.addView(view, 0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block4: {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.ensureTarget();
            if (!this.customViewSet) {
                throw (Throwable)new Exception("Custom View has not been initialized");
            }
            if (this.mTarget == null) {
                return;
            }
            int width = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft()), (int)0x40000000);
            int height = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
            View view = this.mTarget;
            if (view != null) {
                view.measure(width, height);
            }
            this.mBar.measure(width, height);
            if (this.customView == null) break block4;
            View view2 = this.customView;
            if (view2 != null) {
                view2.measure(width, height);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureTarget() {
        if (this.mTarget != null) {
            return;
        }
        if (this.getChildCount() > 0) {
            int n = 0;
            int n2 = this.getChildCount();
            while (n < n2) {
                void i;
                View child = this.getChildAt((int)i);
                if (Intrinsics.areEqual((Object)child, (Object)((Object)this.mBar)) ^ true) {
                    View view = this.mTarget = child;
                    if ((view != null ? view.getBackground() : null) == null) {
                        View view2 = this.mTarget;
                        if (view2 != null) {
                            view2.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
                        }
                    }
                    View view3 = this.mTarget;
                    Integer n3 = view3 != null ? Integer.valueOf(view3.getPaddingTop()) : null;
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mTargetPaddingTop = n3;
                    View view4 = this.mTarget;
                    Integer n4 = view4 != null ? Integer.valueOf(view4.getPaddingBottom()) : null;
                    if (n4 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mTargetPaddingBottom = n4;
                    View view5 = this.mTarget;
                    Integer n5 = view5 != null ? Integer.valueOf(view5.getPaddingRight()) : null;
                    if (n5 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mTargetPaddingRight = n5;
                    View view6 = this.mTarget;
                    Integer n6 = view6 != null ? Integer.valueOf(view6.getPaddingLeft()) : null;
                    if (n6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mTargetPaddingLeft = n6;
                }
                ++i;
            }
        }
    }

    public boolean onInterceptTouchEvent(@Nullable MotionEvent ev) {
        int initialMotionY;
        Integer n;
        if (!this.isEnabled() || this.canChildScrollUp() || this.mRefreshing) {
            return false;
        }
        MotionEvent motionEvent = ev;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getActionMasked()) : null;
        int n3 = 0;
        if (n2 != null && n2 == 0) {
            this.setTargetOffsetTop(0);
            this.mActivePointerId = ev.getPointerId(0);
            this.mIsBeingDragged = false;
            initialMotionY = this.getMotionEventY(ev, this.mActivePointerId);
            if (initialMotionY == -1) {
                return false;
            }
            this.mInitialMotionY = initialMotionY;
        } else {
            Integer n4 = n;
            initialMotionY = 2;
            if (n4 != null && n4 == initialMotionY) {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                int y = this.getMotionEventY(ev, this.mActivePointerId);
                if (y == -1) {
                    return false;
                }
                int yDiff = y - this.mInitialMotionY;
                if (yDiff > this.mTouchSlop && !this.mIsBeingDragged) {
                    this.mIsBeingDragged = true;
                }
            } else {
                Integer n5 = n;
                n3 = 3;
                if (n5 != null && n5 == n3) {
                    this.mIsBeingDragged = false;
                    this.mActivePointerId = -1;
                } else {
                    Integer n6 = n;
                    n3 = 6;
                    if (n6 != null && n6 == n3) {
                        this.onSecondaryPointerUp(ev);
                    }
                }
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(@Nullable MotionEvent ev) {
        int pointerIndex;
        Integer n;
        if (!this.mIsBeingDragged) {
            return super.onTouchEvent(ev);
        }
        MotionEvent motionEvent = ev;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getActionMasked()) : null;
        int n3 = 2;
        if (n2 != null && n2 == n3) {
            pointerIndex = ev.findPointerIndex(this.mActivePointerId);
            if (pointerIndex < 0) {
                return false;
            }
            float y = ev.getY(pointerIndex);
            float yDiff = y - (float)this.mInitialMotionY;
            float scrollTop = yDiff * this.DRAG_RATE;
            this.mCurrentDragPercent = scrollTop / (float)this.mTotalDragDistance;
            if (this.mCurrentDragPercent < 0.0f) {
                return false;
            }
            float f = 1.0f;
            float f2 = this.mCurrentDragPercent;
            boolean bl = false;
            f2 = Math.abs(f2);
            bl = false;
            float boundedDragPercent = Math.min(f, f2);
            boolean bl2 = false;
            float extraOS = Math.abs(scrollTop) - (float)this.mTotalDragDistance;
            float slingshotDist = this.mTotalDragDistance;
            float f3 = 0.0f;
            float f4 = slingshotDist * (float)2;
            int n4 = 0;
            f4 = Math.min(extraOS, f4) / slingshotDist;
            n4 = 0;
            float tensionSlingshotPercent = Math.max(f3, f4);
            f4 = tensionSlingshotPercent / (float)4;
            n4 = 2;
            float f5 = tensionSlingshotPercent / (float)4;
            boolean bl3 = false;
            float f6 = (float)Math.pow(f4, n4);
            float tensionPercent = (f5 - f6) * 2.0f;
            float extraMove = slingshotDist * tensionPercent / (float)2;
            int targetY = (int)(slingshotDist * boundedDragPercent + extraMove);
            float offsetScrollTop = scrollTop - (float)(this.mTotalDragDistance / 2);
            if (offsetScrollTop > 0.0f) {
                this.mBar.setPercent((float)200 * offsetScrollTop / (float)this.mTotalDragDistance);
                this.mCurrentDragPercent = offsetScrollTop / (float)this.mTotalDragDistance * (float)2;
            }
            this.setTargetOffsetTop(targetY - this.mCurrentOffsetTop);
        } else {
            int index;
            Integer n5 = n;
            pointerIndex = 5;
            if (n5 != null && n5 == pointerIndex) {
                index = ev.getActionIndex();
                this.mActivePointerId = ev.getPointerId(index);
            } else {
                Integer n6 = n;
                index = 6;
                if (n6 != null && n6 == index) {
                    this.onSecondaryPointerUp(ev);
                } else {
                    Integer n7 = n;
                    index = 1;
                    if (n7 != null && n7 == index) {
                        if (this.mActivePointerId == -1) {
                            return false;
                        }
                        pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        float y = ev.getY(pointerIndex);
                        float overScrollTop = (y - (float)this.mInitialMotionY) * this.DRAG_RATE;
                        this.mIsBeingDragged = false;
                        if (overScrollTop > (float)this.mTotalDragDistance) {
                            this.setRefreshing(true, true);
                        } else {
                            this.mRefreshing = false;
                            this.animateOffsetToStartPosition();
                        }
                        this.mActivePointerId = -1;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private final boolean canChildScrollUp() {
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    private final void setTargetOffsetTop(int offset) {
        View view = this.mTarget;
        if (view != null) {
            view.offsetTopAndBottom(offset);
        }
        View view2 = this.mTarget;
        Integer n = view2 != null ? Integer.valueOf(view2.getTop()) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.mCurrentOffsetTop = n;
    }

    private final int getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = ev.findPointerIndex(activePointerId);
        if (index < 0) {
            return -1;
        }
        return (int)ev.getY(index);
    }

    private final void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    public final int dp2px(int dp) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return MathKt.roundToInt((float)((float)dp * density));
    }

    private final void moveToStart(float interpolatedTime) {
        int targetTop = this.mFrom - (int)((float)this.mFrom * interpolatedTime);
        float targetPercent = this.mFromDragPercent * (1.0f - interpolatedTime);
        View view = this.mTarget;
        Integer n = view != null ? Integer.valueOf(view.getTop()) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int offset = targetTop - n;
        this.mCurrentDragPercent = targetPercent;
        this.mBar.setPercent((float)100 * this.mCurrentDragPercent);
        View view2 = this.mTarget;
        if (view2 != null) {
            view2.setPadding(this.mTargetPaddingLeft, this.mTargetPaddingTop, this.mTargetPaddingRight, this.mTargetPaddingBottom + targetTop);
        }
        this.setTargetOffsetTop(offset);
    }

    public final void setRefreshing(boolean refreshing) {
        if (this.mRefreshing != refreshing) {
            this.setRefreshing(refreshing, false);
        }
    }

    private final void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mRefreshing != refreshing) {
            this.mNotify = notify;
            this.ensureTarget();
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.mBar.setPercent(1.0f);
                this.animateOffsetToCorrectPosition();
            } else {
                this.animateOffsetToStartPosition();
            }
        }
    }

    private final void animateOffsetToStartPosition() {
        this.mFrom = this.mCurrentOffsetTop;
        this.mFromDragPercent = this.mCurrentDragPercent;
        long l = (long)((float)this.MAX_OFFSET_ANIMATION_DURATION * this.mFromDragPercent);
        boolean bl = false;
        long animationDuration = Math.abs(l);
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration(animationDuration);
        this.mAnimateToStartPosition.setInterpolator(this.mDecelerateInterpolator);
        this.mAnimateToStartPosition.setAnimationListener(this.mToStartListener);
        this.mBar.stop();
        this.mBar.clearAnimation();
        this.mBar.startAnimation(this.mAnimateToStartPosition);
    }

    private final void animateOffsetToCorrectPosition() {
        block5: {
            this.mFrom = this.mCurrentOffsetTop;
            this.mFromDragPercent = this.mCurrentDragPercent;
            this.mAnimateToCorrectPosition.reset();
            this.mAnimateToCorrectPosition.setDuration(this.MAX_OFFSET_ANIMATION_DURATION);
            this.mAnimateToCorrectPosition.setInterpolator(this.mDecelerateInterpolator);
            this.mBar.clearAnimation();
            this.mBar.startAnimation(this.mAnimateToCorrectPosition);
            if (this.mRefreshing) {
                this.mBar.start();
                if (this.mNotify) {
                    InstaRefreshCallback instaRefreshCallback = this.callback;
                    if (instaRefreshCallback != null) {
                        instaRefreshCallback.onRefresh();
                    }
                }
            } else {
                this.mBar.stop();
                this.animateOffsetToStartPosition();
            }
            View view = this.mTarget;
            Integer n = view != null ? Integer.valueOf(view.getTop()) : null;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.mCurrentOffsetTop = n;
            View view2 = this.mTarget;
            if (view2 == null) break block5;
            view2.setPadding(this.mTargetPaddingLeft, this.mTargetPaddingTop, this.mTargetPaddingRight, this.mTotalDragDistance);
        }
    }

    public final int getTotalDragDistance() {
        return this.mTotalDragDistance;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        block2: {
            int width;
            block3: {
                this.ensureTarget();
                if (this.mTarget == null) {
                    return;
                }
                int height = this.getMeasuredHeight();
                width = this.getMeasuredWidth();
                int left = this.getPaddingLeft();
                int top = this.getPaddingTop();
                int right = this.getPaddingRight();
                int bottom = this.getPaddingBottom();
                View view = this.mTarget;
                if (view != null) {
                    view.layout(left, top + this.mCurrentOffsetTop, left + width - right, top + height - bottom + this.mCurrentOffsetTop);
                }
                this.mBar.layout(left, top, left + width - right, top + height - bottom);
                if (this.customView == null) break block2;
                if (this.DRAG_MAX_DISTANCE - this.customViewHeight > 0) break block3;
                View view2 = this.customView;
                if (view2 == null) break block2;
                view2.layout(left, top + this.dp2px(30), left + width - right, this.customViewHeight + this.dp2px(30));
                break block2;
            }
            int diff = this.DRAG_MAX_DISTANCE - this.customViewHeight;
            int center = (width - this.customViewWidth) / 2;
            View view = this.customView;
            if (view == null) break block2;
            view.layout(center, diff / 2, this.customViewWidth + center, this.DRAG_MAX_DISTANCE - diff / 2);
        }
    }

    public final void setRefreshListener(@NotNull Function0<Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.callback = new InstaRefreshCallback(action){
            final /* synthetic */ Function0 $action;

            public void onRefresh() {
                this.$action.invoke();
            }
            {
                this.$action = $captured_local_variable$0;
            }
        };
    }

    public final void setRefreshListener(@NotNull InstaRefreshCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callback = callback;
    }

    @JvmOverloads
    public IGRefreshLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.DRAG_RATE = 0.5f;
        this.DRAG_MAX_DISTANCE = 120;
        this.MAX_OFFSET_ANIMATION_DURATION = 700;
        this.DECELERATE_INTERPOLATION_FACTOR = 2.0f;
        this.mBar = new CircleProgressBar(context, null, 0, 6, null);
        this.mDecelerateInterpolator = (Interpolator)new DecelerateInterpolator(this.DECELERATE_INTERPOLATION_FACTOR);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.setRefreshing(false);
        this.setupAttributes(attrs);
        this.mTotalDragDistance = this.dp2px(this.DRAG_MAX_DISTANCE);
        this.setBackgroundColor(-1);
        this.setWillNotDraw(false);
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
        this.mAnimateToStartPosition = new Animation(this){
            final /* synthetic */ IGRefreshLayout this$0;

            public void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                IGRefreshLayout.access$moveToStart(this.this$0, interpolatedTime);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mAnimateToCorrectPosition = new Animation(this){
            final /* synthetic */ IGRefreshLayout this$0;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                int targetTop = 0;
                int endTarget = IGRefreshLayout.access$getMTotalDragDistance$p(this.this$0);
                targetTop = IGRefreshLayout.access$getMFrom$p(this.this$0) + (int)((float)(endTarget - IGRefreshLayout.access$getMFrom$p(this.this$0)) * interpolatedTime);
                View view = IGRefreshLayout.access$getMTarget$p(this.this$0);
                Integer n = view != null ? Integer.valueOf(view.getTop()) : null;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                int offset = targetTop - n;
                IGRefreshLayout.access$setMCurrentDragPercent$p(this.this$0, IGRefreshLayout.access$getMFromDragPercent$p(this.this$0) - (IGRefreshLayout.access$getMFromDragPercent$p(this.this$0) - 1.0f) * interpolatedTime);
                IGRefreshLayout.access$getMBar$p(this.this$0).setPercent((float)100 * IGRefreshLayout.access$getMCurrentDragPercent$p(this.this$0));
                IGRefreshLayout.access$setTargetOffsetTop(this.this$0, offset);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mToStartListener = new Animation.AnimationListener(this){
            final /* synthetic */ IGRefreshLayout this$0;

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                IGRefreshLayout.access$getMBar$p(this.this$0).stop();
                View view = IGRefreshLayout.access$getMTarget$p(this.this$0);
                Integer n = view != null ? Integer.valueOf(view.getTop()) : null;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                IGRefreshLayout.access$setMCurrentOffsetTop$p(this.this$0, n);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ IGRefreshLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public IGRefreshLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public IGRefreshLayout(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$moveToStart(IGRefreshLayout $this, float interpolatedTime) {
        $this.moveToStart(interpolatedTime);
    }

    public static final /* synthetic */ int access$getMTotalDragDistance$p(IGRefreshLayout $this) {
        return $this.mTotalDragDistance;
    }

    public static final /* synthetic */ void access$setMTotalDragDistance$p(IGRefreshLayout $this, int n) {
        $this.mTotalDragDistance = n;
    }

    public static final /* synthetic */ int access$getMFrom$p(IGRefreshLayout $this) {
        return $this.mFrom;
    }

    public static final /* synthetic */ void access$setMFrom$p(IGRefreshLayout $this, int n) {
        $this.mFrom = n;
    }

    public static final /* synthetic */ View access$getMTarget$p(IGRefreshLayout $this) {
        return $this.mTarget;
    }

    public static final /* synthetic */ void access$setMTarget$p(IGRefreshLayout $this, View view) {
        $this.mTarget = view;
    }

    public static final /* synthetic */ float access$getMCurrentDragPercent$p(IGRefreshLayout $this) {
        return $this.mCurrentDragPercent;
    }

    public static final /* synthetic */ void access$setMCurrentDragPercent$p(IGRefreshLayout $this, float f) {
        $this.mCurrentDragPercent = f;
    }

    public static final /* synthetic */ float access$getMFromDragPercent$p(IGRefreshLayout $this) {
        return $this.mFromDragPercent;
    }

    public static final /* synthetic */ void access$setMFromDragPercent$p(IGRefreshLayout $this, float f) {
        $this.mFromDragPercent = f;
    }

    public static final /* synthetic */ BaseProgressBar access$getMBar$p(IGRefreshLayout $this) {
        return $this.mBar;
    }

    public static final /* synthetic */ void access$setMBar$p(IGRefreshLayout $this, BaseProgressBar baseProgressBar) {
        $this.mBar = baseProgressBar;
    }

    public static final /* synthetic */ void access$setTargetOffsetTop(IGRefreshLayout $this, int offset) {
        $this.setTargetOffsetTop(offset);
    }

    public static final /* synthetic */ int access$getMCurrentOffsetTop$p(IGRefreshLayout $this) {
        return $this.mCurrentOffsetTop;
    }

    public static final /* synthetic */ void access$setMCurrentOffsetTop$p(IGRefreshLayout $this, int n) {
        $this.mCurrentOffsetTop = n;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout$InstaRefreshCallback;", "", "onRefresh", "", "fdpulltorefresh_release"})
    public static interface InstaRefreshCallback {
        public void onRefresh();
    }
}

