/*
 * Decompiled with CFR 0.152.
 */
package com.filippudak.ProgressPieView;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.filippudak.ProgressPieView.R;

public class ProgressPieView
extends View {
    public static final int FILL_TYPE_RADIAL = 0;
    public static final int FILL_TYPE_CENTER = 1;
    public static final int SLOW_ANIMATION_SPEED = 50;
    public static final int MEDIUM_ANIMATION_SPEED = 25;
    public static final int FAST_ANIMATION_SPEED = 1;
    private static final int DEFAULT_MAX = 100;
    private static final int DEFAULT_PROGRESS = 0;
    private static final int DEFAULT_START_ANGLE = -90;
    private static final float DEFAULT_STROKE_WIDTH = 3.0f;
    private static final float DEFAULT_TEXT_SIZE = 14.0f;
    private static final int DEFAULT_VIEW_SIZE = 96;
    private static LruCache<String, Typeface> sTypefaceCache = new LruCache(8);
    private OnProgressListener mListener;
    private DisplayMetrics mDisplayMetrics;
    private int mMax = 100;
    private int mProgress = 0;
    private int mStartAngle = -90;
    private boolean mInverted = false;
    private boolean mCounterclockwise = false;
    private boolean mShowStroke = true;
    private float mStrokeWidth = 3.0f;
    private boolean mShowText = true;
    private float mTextSize = 14.0f;
    private String mText;
    private String mTypeface;
    private boolean mShowImage = true;
    private Drawable mImage;
    private Rect mImageRect;
    private Paint mStrokePaint;
    private Paint mTextPaint;
    private Paint mProgressPaint;
    private Paint mBackgroundPaint;
    private RectF mInnerRectF;
    private int mProgressFillType = 0;
    private int mAnimationSpeed = 25;
    private AnimationHandler mAnimationHandler = new AnimationHandler();
    private int mViewSize;

    public ProgressPieView(Context context) {
        this(context, null);
    }

    public ProgressPieView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressPieView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        this.mStrokeWidth *= this.mDisplayMetrics.density;
        this.mTextSize *= this.mDisplayMetrics.scaledDensity;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressPieView);
        Resources res = this.getResources();
        this.mMax = a.getInteger(R.styleable.ProgressPieView_ppvMax, this.mMax);
        this.mProgress = a.getInteger(R.styleable.ProgressPieView_ppvProgress, this.mProgress);
        this.mStartAngle = a.getInt(R.styleable.ProgressPieView_ppvStartAngle, this.mStartAngle);
        this.mInverted = a.getBoolean(R.styleable.ProgressPieView_ppvInverted, this.mInverted);
        this.mCounterclockwise = a.getBoolean(R.styleable.ProgressPieView_ppvCounterclockwise, this.mCounterclockwise);
        this.mStrokeWidth = a.getDimension(R.styleable.ProgressPieView_ppvStrokeWidth, this.mStrokeWidth);
        this.mTypeface = a.getString(R.styleable.ProgressPieView_ppvTypeface);
        this.mTextSize = a.getDimension(R.styleable.ProgressPieView_android_textSize, this.mTextSize);
        this.mText = a.getString(R.styleable.ProgressPieView_android_text);
        this.mShowStroke = a.getBoolean(R.styleable.ProgressPieView_ppvShowStroke, this.mShowStroke);
        this.mShowText = a.getBoolean(R.styleable.ProgressPieView_ppvShowText, this.mShowText);
        this.mImage = a.getDrawable(R.styleable.ProgressPieView_ppvImage);
        int backgroundColor = res.getColor(R.color.default_background_color);
        backgroundColor = a.getColor(R.styleable.ProgressPieView_ppvBackgroundColor, backgroundColor);
        int progressColor = res.getColor(R.color.default_progress_color);
        progressColor = a.getColor(R.styleable.ProgressPieView_ppvProgressColor, progressColor);
        int strokeColor = res.getColor(R.color.default_stroke_color);
        strokeColor = a.getColor(R.styleable.ProgressPieView_ppvStrokeColor, strokeColor);
        int textColor = res.getColor(R.color.default_text_color);
        textColor = a.getColor(R.styleable.ProgressPieView_android_textColor, textColor);
        this.mProgressFillType = a.getInteger(R.styleable.ProgressPieView_ppvProgressFillType, this.mProgressFillType);
        a.recycle();
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(backgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setColor(progressColor);
        this.mProgressPaint.setStyle(Paint.Style.FILL);
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setColor(strokeColor);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(this.mStrokeWidth);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mInnerRectF = new RectF();
        this.mImageRect = new Rect();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = ProgressPieView.resolveSize((int)96, (int)widthMeasureSpec);
        int height = ProgressPieView.resolveSize((int)96, (int)heightMeasureSpec);
        this.mViewSize = Math.min(width, height);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mInnerRectF.set(0.0f, 0.0f, (float)this.mViewSize, (float)this.mViewSize);
        this.mInnerRectF.offset((float)((this.getWidth() - this.mViewSize) / 2), (float)((this.getHeight() - this.mViewSize) / 2));
        if (this.mShowStroke) {
            int halfBorder = (int)(this.mStrokePaint.getStrokeWidth() / 2.0f + 0.5f);
            this.mInnerRectF.inset((float)halfBorder, (float)halfBorder);
        }
        float centerX = this.mInnerRectF.centerX();
        float centerY = this.mInnerRectF.centerY();
        canvas.drawArc(this.mInnerRectF, 0.0f, 360.0f, true, this.mBackgroundPaint);
        switch (this.mProgressFillType) {
            case 0: {
                float sweepAngle = 360 * this.mProgress / this.mMax;
                if (this.mInverted) {
                    sweepAngle -= 360.0f;
                }
                if (this.mCounterclockwise) {
                    sweepAngle = -sweepAngle;
                }
                canvas.drawArc(this.mInnerRectF, (float)this.mStartAngle, sweepAngle, true, this.mProgressPaint);
                break;
            }
            case 1: {
                float radius = (float)(this.mViewSize / 2) * ((float)this.mProgress / (float)this.mMax);
                if (this.mShowStroke) {
                    radius = radius + 0.5f - this.mStrokePaint.getStrokeWidth();
                }
                canvas.drawCircle(centerX, centerY, radius, this.mProgressPaint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Progress Fill = " + this.mProgressFillType);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mText) && this.mShowText) {
            if (!TextUtils.isEmpty((CharSequence)this.mTypeface)) {
                AssetManager assets;
                Typeface typeface = (Typeface)sTypefaceCache.get((Object)this.mTypeface);
                if (null == typeface && null != this.getResources() && null != (assets = this.getResources().getAssets())) {
                    typeface = Typeface.createFromAsset((AssetManager)assets, (String)this.mTypeface);
                    sTypefaceCache.put((Object)this.mTypeface, (Object)typeface);
                }
                this.mTextPaint.setTypeface(typeface);
            }
            int xPos = (int)centerX;
            int yPos = (int)(centerY - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
            canvas.drawText(this.mText, (float)xPos, (float)yPos, this.mTextPaint);
        }
        if (null != this.mImage && this.mShowImage) {
            int drawableSize = this.mImage.getIntrinsicWidth();
            this.mImageRect.set(0, 0, drawableSize, drawableSize);
            this.mImageRect.offset((this.getWidth() - drawableSize) / 2, (this.getHeight() - drawableSize) / 2);
            this.mImage.setBounds(this.mImageRect);
            this.mImage.draw(canvas);
        }
        if (this.mShowStroke) {
            canvas.drawOval(this.mInnerRectF, this.mStrokePaint);
        }
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        if (max <= 0 || max < this.mProgress) {
            throw new IllegalArgumentException(String.format("Max (%d) must be > 0 and >= %d", max, this.mProgress));
        }
        this.mMax = max;
        this.invalidate();
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.mAnimationSpeed = animationSpeed;
    }

    public int getAnimationSpeed() {
        return this.mAnimationSpeed;
    }

    public void animateProgressFill() {
        this.mAnimationHandler.removeMessages(0);
        this.mAnimationHandler.setAnimateTo(this.mMax);
        this.mAnimationHandler.sendEmptyMessage(0);
        this.invalidate();
    }

    public void animateProgressFill(int animateTo) {
        this.mAnimationHandler.removeMessages(0);
        if (animateTo > this.mMax || animateTo < 0) {
            throw new IllegalArgumentException(String.format("Animation progress (%d) is greater than the max progress (%d) or lower than 0 ", animateTo, this.mMax));
        }
        this.mAnimationHandler.setAnimateTo(animateTo);
        this.mAnimationHandler.sendEmptyMessage(0);
        this.invalidate();
    }

    public void stopAnimating() {
        this.mAnimationHandler.removeMessages(0);
        this.mAnimationHandler.setAnimateTo(this.mProgress);
        this.invalidate();
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int progress) {
        if (progress > this.mMax || progress < 0) {
            throw new IllegalArgumentException(String.format("Progress (%d) must be between %d and %d", progress, 0, this.mMax));
        }
        this.mProgress = progress;
        if (null != this.mListener) {
            if (this.mProgress == this.mMax) {
                this.mListener.onProgressCompleted();
            } else {
                this.mListener.onProgressChanged(this.mProgress, this.mMax);
            }
        }
        this.invalidate();
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(int startAngle) {
        this.mStartAngle = startAngle;
    }

    public boolean isInverted() {
        return this.mInverted;
    }

    public void setInverted(boolean inverted) {
        this.mInverted = inverted;
    }

    public boolean isCounterclockwise() {
        return this.mCounterclockwise;
    }

    public void setCounterclockwise(boolean counterclockwise) {
        this.mCounterclockwise = counterclockwise;
    }

    public int getProgressColor() {
        return this.mProgressPaint.getColor();
    }

    public void setProgressColor(int color2) {
        this.mProgressPaint.setColor(color2);
        this.invalidate();
    }

    public int getBackgroundColor() {
        return this.mBackgroundPaint.getColor();
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundPaint.setColor(color2);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextPaint.getColor();
    }

    public void setTextColor(int color2) {
        this.mTextPaint.setColor(color2);
        this.invalidate();
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int sizeSp) {
        this.mTextSize = (float)sizeSp * this.mDisplayMetrics.scaledDensity;
        this.mTextPaint.setTextSize(this.mTextSize);
        this.invalidate();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
        this.invalidate();
    }

    public String getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(String typeface) {
        this.mTypeface = typeface;
        this.invalidate();
    }

    public boolean isTextShowing() {
        return this.mShowText;
    }

    public void setShowText(boolean showText) {
        this.mShowText = showText;
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.mStrokePaint.getColor();
    }

    public void setStrokeColor(int color2) {
        this.mStrokePaint.setColor(color2);
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(int widthDp) {
        this.mStrokeWidth = (float)widthDp * this.mDisplayMetrics.density;
        this.mStrokePaint.setStrokeWidth(this.mStrokeWidth);
        this.invalidate();
    }

    public boolean isStrokeShowing() {
        return this.mShowStroke;
    }

    public void setShowStroke(boolean showStroke) {
        this.mShowStroke = showStroke;
        this.invalidate();
    }

    public Drawable getImageDrawable() {
        return this.mImage;
    }

    public void setImageDrawable(Drawable image) {
        this.mImage = image;
        this.invalidate();
    }

    public void setImageResource(int resId) {
        if (null != this.getResources()) {
            this.mImage = this.getResources().getDrawable(resId);
            this.invalidate();
        }
    }

    public boolean isImageShowing() {
        return this.mShowImage;
    }

    public void setShowImage(boolean showImage) {
        this.mShowImage = showImage;
        this.invalidate();
    }

    public int getProgressFillType() {
        return this.mProgressFillType;
    }

    public void setProgressFillType(int fillType) {
        this.mProgressFillType = fillType;
    }

    public void setOnProgressListener(OnProgressListener listener) {
        this.mListener = listener;
    }

    private class AnimationHandler
    extends Handler {
        private int mAnimateTo;

        private AnimationHandler() {
        }

        public void setAnimateTo(int animateTo) {
            this.mAnimateTo = animateTo;
        }

        public void handleMessage(Message msg) {
            if (ProgressPieView.this.mProgress > this.mAnimateTo) {
                ProgressPieView.this.setProgress(ProgressPieView.this.mProgress - 1);
                this.sendEmptyMessageDelayed(0, ProgressPieView.this.mAnimationSpeed);
            } else if (ProgressPieView.this.mProgress < this.mAnimateTo) {
                ProgressPieView.this.setProgress(ProgressPieView.this.mProgress + 1);
                this.sendEmptyMessageDelayed(0, ProgressPieView.this.mAnimationSpeed);
            } else {
                this.removeMessages(0);
            }
        }
    }

    public static interface OnProgressListener {
        public void onProgressChanged(int var1, int var2);

        public void onProgressCompleted();
    }
}

