/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.installer.jruby;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.logging.Logger;
import org.jruby.Main;

public class JRubyCaller {
    private final Logger logger;

    public File unpack(String gemName, String gemVersion) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Downloading " + gemName);
        }
        File folder = this.generateTempFolder(gemName);
        String[] unpackArgs = new String[]{"-S", "gem", "unpack", gemName, "--target", folder.getAbsolutePath()};
        unpackArgs = this.addVersionToArgs(gemVersion, unpackArgs);
        Main.main((String[])unpackArgs);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(gemName + "downloaded");
        }
        return folder;
    }

    protected File generateTempFolder(String gemName) throws IOException {
        File folder = File.createTempFile(gemName, "");
        FileUtils.deleteQuietly((File)folder);
        FileUtils.forceMkdir((File)folder);
        FileUtils.forceDeleteOnExit((File)folder);
        return folder;
    }

    protected String[] addVersionToArgs(String gemVersion, String[] unpackArgs) {
        if (StringUtils.isNotBlank((CharSequence)gemVersion)) {
            this.logger.info("Version : " + gemVersion);
            unpackArgs = (String[])ArrayUtils.addAll((Object[])unpackArgs, (Object[])new String[]{"-v", gemVersion});
        } else {
            this.logger.info("Version : Last");
        }
        return unpackArgs;
    }

    @ConstructorProperties(value={"logger"})
    public JRubyCaller(Logger logger) {
        this.logger = logger;
    }
}

