/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.provider;

import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.provider.MessageSourceLoader;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.serviceloader.MessageBundles;
import com.github.fge.msgsimple.serviceloader.MsgSimpleMessageBundle;
import com.github.fge.msgsimple.source.MessageSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LoadingMessageSourceProvider
implements MessageSourceProvider {
    private static final int NTHREADS = 5;
    private static final MessageBundle BUNDLE = MessageBundles.forClass(MsgSimpleMessageBundle.class);
    private final MessageSourceLoader loader;
    private final MessageSource defaultSource;
    private final long nr;
    private final TimeUnit unit;
    private final ExecutorService service = Executors.newFixedThreadPool(5);
    private final Map<Locale, FutureTask<MessageSource>> sources = new HashMap<Locale, FutureTask<MessageSource>>();

    private LoadingMessageSourceProvider(Builder builder) {
        this.loader = builder.loader;
        this.defaultSource = builder.defaultSource;
        this.nr = builder.nr;
        this.unit = builder.unit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageSource getMessageSource(Locale locale) {
        FutureTask<MessageSource> task;
        Map<Locale, FutureTask<MessageSource>> map = this.sources;
        synchronized (map) {
            task = this.sources.get(locale);
            if (task == null || task.isCancelled()) {
                task = this.loadingTask(locale);
                this.sources.put(locale, task);
                this.service.execute(task);
            }
        }
        try {
            MessageSource source = task.get(this.nr, this.unit);
            return source == null ? this.defaultSource : source;
        }
        catch (InterruptedException ignored) {
            return this.defaultSource;
        }
        catch (ExecutionException ignored) {
            return this.defaultSource;
        }
        catch (TimeoutException ignored) {
            task.cancel(true);
            return this.defaultSource;
        }
    }

    private FutureTask<MessageSource> loadingTask(final Locale locale) {
        return new FutureTask<MessageSource>(new Callable<MessageSource>(){

            @Override
            public MessageSource call() throws IOException {
                return LoadingMessageSourceProvider.this.loader.load(locale);
            }
        });
    }

    public static final class Builder {
        private MessageSourceLoader loader;
        private MessageSource defaultSource;
        private long nr = 5L;
        private TimeUnit unit = TimeUnit.SECONDS;

        private Builder() {
        }

        public Builder setLoader(MessageSourceLoader loader) {
            if (loader == null) {
                throw new NullPointerException(BUNDLE.getMessage("cfg.nullLoader"));
            }
            this.loader = loader;
            return this;
        }

        public Builder setDefaultSource(MessageSource defaultSource) {
            if (defaultSource == null) {
                throw new NullPointerException(BUNDLE.getMessage("cfg.nullDefaultSource"));
            }
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder setTimeout(long nr, TimeUnit unit) {
            if (nr <= 0L) {
                throw new IllegalArgumentException(BUNDLE.getMessage("cfg.nonPositiveTimeout"));
            }
            if (unit == null) {
                throw new NullPointerException(BUNDLE.getMessage("cfg.nullTimeUnit"));
            }
            this.nr = nr;
            this.unit = unit;
            return this;
        }

        public MessageSourceProvider build() {
            if (this.loader == null) {
                throw new IllegalArgumentException(BUNDLE.getMessage("cfg.noLoader"));
            }
            return new LoadingMessageSourceProvider(this);
        }
    }
}

