/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.CachingProcessor;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class ValidationProcessor
implements Processor<FullData, FullData> {
    private final MessageBundle syntaxMessages;
    private final MessageBundle validationMessages;
    private final Processor<SchemaContext, ValidatorList> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(ValidationConfiguration cfg, Processor<SchemaContext, ValidatorList> processor) {
        this.syntaxMessages = cfg.getSyntaxMessages();
        this.validationMessages = cfg.getValidationMessages();
        this.processor = new CachingProcessor(processor, SchemaContextEquivalence.getInstance());
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
    }

    public FullData process(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaContext context = new SchemaContext(input);
        ValidatorList fullContext = (ValidatorList)this.processor.process(report, (MessageProvider)context);
        if (fullContext == null) {
            ProcessingMessage message2;
            String msg = this.syntaxMessages.getMessage("core.invalidSchema");
            ArrayNode arrayNode = JacksonUtils.nodeFactory().arrayNode();
            for (ProcessingMessage message2 : report) {
                JsonNode node = message2.asJson();
                if (!"syntax".equals(node.path("domain").asText())) continue;
                arrayNode.add(node);
            }
            StringBuilder sb = new StringBuilder(msg);
            sb.append("\nSyntax errors:\n");
            sb.append(JacksonUtils.prettyPrint((JsonNode)arrayNode));
            message2 = new ProcessingMessage().setMessage(sb.toString());
            throw new InvalidSchemaException(message2);
        }
        SchemaContext newContext = fullContext.getContext();
        FullData data = new FullData(newContext.getSchema(), input.getInstance(), input.isDeepCheck());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, this.validationMessages, data);
        }
        if (!report.isSuccess() && !data.isDeepCheck()) {
            return input;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.size() == 0) {
            return input;
        }
        if (node.isArray()) {
            this.processArray(report, data);
        } else {
            this.processObject(report, data);
        }
        return input;
    }

    private void processArray(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = (ArraySchemaSelector)this.arrayCache.getUnchecked((Object)digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.of((Object)index, (Object[])new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = (ObjectSchemaSelector)this.objectCache.getUnchecked((Object)digest);
        ArrayList fields = Lists.newArrayList((Iterator)node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of((Object)field, (Object[])new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            public ArraySchemaSelector load(JsonNode key) {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            public ObjectSchemaSelector load(JsonNode key) {
                return new ObjectSchemaSelector(key);
            }
        };
    }

    public String toString() {
        return "validation processor";
    }
}

