/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.examples.Utils;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.load.uri.URITransformer;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.report.ProcessingReport;
import java.io.IOException;

public final class Example6 {
    private static final String FROM = "http://my.site/schemas/fstab.json#";
    private static final String TO = "resource:/com/github/fge/jsonschema/examples/fstab.json#";

    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode good = Utils.loadResource("/fstab-good.json");
        JsonNode bad = Utils.loadResource("/fstab-bad.json");
        JsonNode bad2 = Utils.loadResource("/fstab-bad2.json");
        URITransformer transformer = URITransformer.newBuilder().addSchemaRedirect(FROM, TO).freeze();
        LoadingConfiguration cfg = LoadingConfiguration.newBuilder().setURITransformer(transformer).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(FROM);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
        report = schema.validate(bad2);
        System.out.println(report);
    }
}

