/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.net.URI;
import java.net.URISyntaxException;

public final class URIAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new URIAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private URIAttribute() {
        super("uri", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            new URI(value);
        }
        catch (URISyntaxException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.invalidURI").putArgument("value", (Object)value));
        }
    }
}

