/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key, T value) {
        BUNDLE.checkNotNull((Object)key, "dictionary.nullKey");
        BUNDLE.checkNotNull(value, "dictionary.nullValue");
        this.entries.put(key, value);
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        BUNDLE.checkNotNull(other, "dictionary.nullDict");
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key) {
        this.entries.remove(key);
        return this;
    }

    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

