/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public final class FormatProcessor
implements Processor<FullValidationContext, FullValidationContext> {
    private final Dictionary<FormatAttribute> dict;

    public FormatProcessor(Dictionary<FormatAttribute> dict) {
        this.dict = dict;
    }

    @Override
    public FullValidationContext process(ProcessingReport report, FullValidationContext input) throws ProcessingException {
        ValidationContext context = input.getContext();
        JsonNode node = context.getSchema().getNode().get("format");
        if (node == null) {
            return input;
        }
        String fmt = node.textValue();
        FormatAttribute attr = this.dict.get(fmt);
        if (attr == null) {
            report.warn(input.newMessage().put("domain", "validation").put("keyword", "format").message(FormatMessages.FORMAT_NOT_SUPPORTED).put("attribute", fmt));
            return input;
        }
        NodeType type = context.getInstanceType();
        if (!attr.supportedTypes().contains((Object)type)) {
            return input;
        }
        ArrayList validators = Lists.newArrayList((Iterable)input);
        validators.add(FormatProcessor.formatValidator(attr));
        return new FullValidationContext(context, validators);
    }

    private static KeywordValidator formatValidator(final FormatAttribute attr) {
        return new KeywordValidator(){

            @Override
            public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
                attr.validate(report, data);
            }
        };
    }

    public String toString() {
        return "format attribute runner";
    }
}

