/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.build;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.processing.ProcessingCache;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationDigest;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;

public final class ValidatorBuilder
implements Processor<ValidationDigest, FullValidationContext> {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final String ERRMSG = "failed to build keyword validator";
    private final Map<String, ProcessingCache<JsonNode, KeywordValidator>> caches = Maps.newTreeMap();

    public ValidatorBuilder(Dictionary<Constructor<? extends KeywordValidator>> dict) {
        for (Map.Entry<String, Constructor<? extends KeywordValidator>> entry : dict.entries()) {
            String key = entry.getKey();
            ProcessingCache<JsonNode, KeywordValidator> processingCache = new ProcessingCache<JsonNode, KeywordValidator>(EQUIVALENCE, ValidatorBuilder.loader(entry.getValue()));
            this.caches.put(key, processingCache);
        }
    }

    @Override
    public FullValidationContext process(ProcessingReport report, ValidationDigest input) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            ProcessingCache<JsonNode, KeywordValidator> cache = this.caches.get(keyword);
            KeywordValidator validator = cache.get(digest);
            map.put(keyword, validator);
        }
        return new FullValidationContext(input.getData(), map.values());
    }

    private static CacheLoader<Equivalence.Wrapper<JsonNode>, KeywordValidator> loader(final Constructor<? extends KeywordValidator> constructor) {
        return new CacheLoader<Equivalence.Wrapper<JsonNode>, KeywordValidator>(){

            public KeywordValidator load(Equivalence.Wrapper<JsonNode> key) throws ProcessingException {
                try {
                    return (KeywordValidator)constructor.newInstance(key.get());
                }
                catch (InstantiationException e) {
                    throw new ProcessingException(ValidatorBuilder.ERRMSG, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ProcessingException(ValidatorBuilder.ERRMSG, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ProcessingException(ValidatorBuilder.ERRMSG, (Throwable)e);
                }
            }
        };
    }

    public String toString() {
        return "validator builder";
    }
}

