/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.unchecked.FactoryConfigurationError;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.ConfigurationMessages;
import com.github.fge.jsonschema.report.ListReportProvider;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.util.Thawed;

public final class JsonSchemaFactoryBuilder
implements Thawed<JsonSchemaFactory> {
    ReportProvider reportProvider;
    LoadingConfiguration loadingConfiguration;
    ValidationConfiguration validationConfiguration;

    JsonSchemaFactoryBuilder() {
        this.reportProvider = new ListReportProvider(LogLevel.INFO, LogLevel.FATAL);
        this.loadingConfiguration = LoadingConfiguration.byDefault();
        this.validationConfiguration = ValidationConfiguration.byDefault();
    }

    JsonSchemaFactoryBuilder(JsonSchemaFactory factory) {
        this.reportProvider = factory.reportProvider;
    }

    public JsonSchemaFactoryBuilder setReportProvider(ReportProvider reportProvider) {
        if (reportProvider == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_REPORT_PROVIDER));
        }
        this.reportProvider = reportProvider;
        return this;
    }

    public JsonSchemaFactoryBuilder setLoadingConfiguration(LoadingConfiguration loadingConfiguration) {
        if (loadingConfiguration == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_LOADING_CFG));
        }
        this.loadingConfiguration = loadingConfiguration;
        return this;
    }

    public JsonSchemaFactoryBuilder setValidationConfiguration(ValidationConfiguration validationConfiguration) {
        if (validationConfiguration == null) {
            throw new FactoryConfigurationError(new ProcessingMessage().message(ConfigurationMessages.NULL_VALIDATION_CFG));
        }
        this.validationConfiguration = validationConfiguration;
        return this;
    }

    @Override
    public JsonSchemaFactory freeze() {
        return new JsonSchemaFactory(this);
    }
}

