/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

public final class DraftV4TypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final EnumSet<NodeType> ALL_TYPES = EnumSet.allOf(NodeType.class);
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new DraftV4TypeSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeSyntaxChecker() {
        super("type", NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        if (node.isTextual()) {
            String s = node.textValue();
            if (NodeType.fromName(s) == null) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("valid", ALL_TYPES).put("found", s));
            }
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
            return;
        }
        HashSet set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap((Object)element));
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("index", index).put("expected", NodeType.STRING).put("found", type));
                continue;
            }
            if (NodeType.fromName(element.textValue()) != null) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_PRIMITIVE_TYPE).put("index", index).put("valid", ALL_TYPES).put("found", element));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
        }
    }
}

