/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.data;

import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class ValidatedPaths {
    private final ReentrantLock lock = new ReentrantLock();
    private final Set<JsonPointer> validatedPaths = Sets.newHashSet();
    private final Set<JsonPointer> uncheckedPaths = Sets.newHashSet();
    private final List<ProcessingMessage> messages = Lists.newArrayList();
    private boolean valid = false;

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isValidated(JsonPointer currentPointer) {
        JsonPointer closestUnchecked = ValidatedPaths.closestPointer(this.uncheckedPaths, currentPointer);
        JsonPointer closestValidated = ValidatedPaths.closestPointer(this.validatedPaths, currentPointer);
        if (closestValidated == null) {
            return false;
        }
        if (closestUnchecked == null) {
            return true;
        }
        return closestUnchecked.isParentOf(closestValidated);
    }

    public void addValidatedPath(JsonPointer pointer) {
        this.validatedPaths.add(pointer);
        this.uncheckedPaths.remove(pointer);
    }

    public void addUncheckedPath(JsonPointer pointer) {
        this.uncheckedPaths.add(pointer);
    }

    public void addReport(ProcessingReport report) {
        this.messages.addAll(report.getMessages());
        this.valid = report.isSuccess();
    }

    public boolean isValid() {
        return this.valid;
    }

    private static JsonPointer closestPointer(Set<JsonPointer> set, JsonPointer pointer) {
        JsonPointer ret = null;
        for (JsonPointer ptr : set) {
            if (!ptr.isParentOf(pointer)) continue;
            if (ret == null) {
                ret = ptr;
                continue;
            }
            if (!ret.isParentOf(ptr)) continue;
            ret = ptr;
        }
        return ret;
    }
}

