/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.github.fge.jsonschema.exceptions.unchecked.LoadingConfigurationError;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.load.DefaultDownloadersDictionary;
import com.github.fge.jsonschema.load.LoadingConfiguration;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.messages.LoadingMessages;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class LoadingConfigurationBuilder
implements Thawed<LoadingConfiguration> {
    private static final URI EMPTY_NAMESPACE = URI.create("#");
    final DictionaryBuilder<URIDownloader> downloaders;
    URI namespace;
    final Map<URI, URI> schemaRedirects;

    LoadingConfigurationBuilder() {
        this.downloaders = DefaultDownloadersDictionary.get().thaw();
        this.namespace = EMPTY_NAMESPACE;
        this.schemaRedirects = Maps.newHashMap();
    }

    LoadingConfigurationBuilder(LoadingConfiguration cfg) {
        this.downloaders = cfg.downloaders.thaw();
        this.namespace = cfg.namespace;
        this.schemaRedirects = Maps.newHashMap(cfg.schemaRedirects);
    }

    public LoadingConfigurationBuilder addScheme(String scheme, URIDownloader downloader) {
        this.downloaders.addEntry(LoadingConfigurationBuilder.checkScheme(scheme), downloader);
        return this;
    }

    public LoadingConfigurationBuilder removeScheme(String scheme) {
        this.downloaders.removeEntry(scheme);
        return this;
    }

    public LoadingConfigurationBuilder setNamespace(String input) {
        this.namespace = LoadingConfigurationBuilder.checkRef(input);
        return this;
    }

    public LoadingConfigurationBuilder addSchemaRedirect(String source, String destination) {
        URI sourceURI = LoadingConfigurationBuilder.checkRef(source);
        URI destinationURI = LoadingConfigurationBuilder.checkRef(destination);
        this.schemaRedirects.put(sourceURI, destinationURI);
        if (sourceURI.equals(destinationURI)) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingMessages.REDIRECT_TO_SELF).put("uri", sourceURI));
        }
        return this;
    }

    @Override
    public LoadingConfiguration freeze() {
        return new LoadingConfiguration(this);
    }

    private static String checkScheme(String scheme) {
        ProcessingMessage message = new ProcessingMessage();
        if (scheme == null) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.NULL_SCHEME));
        }
        if (scheme.isEmpty()) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.EMPTY_SCHEME));
        }
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.ILLEGAL_SCHEME).put("scheme", scheme));
        }
        return scheme;
    }

    private static URI checkRef(String input) {
        URI uri;
        ProcessingMessage message = new ProcessingMessage();
        if (input == null) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.NULL_URI));
        }
        try {
            uri = new URI(input);
        }
        catch (URISyntaxException ignored) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.INVALID_URI).put("input", input));
        }
        JsonRef ref = JsonRef.fromURI(uri);
        if (!ref.isAbsolute()) {
            throw new LoadingConfigurationError(message.message(LoadingMessages.REF_NOT_ABSOLUTE).put("input", input));
        }
        return ref.getLocator();
    }
}

