/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.google.common.collect.ImmutableList;
import java.util.Collections;

final class ArraySchemaSelector {
    private static final JsonPointer ITEMS = JsonPointer.empty().append("items");
    private static final JsonPointer ADDITIONAL_ITEMS = JsonPointer.empty().append("additionalItems");
    private final boolean hasItems;
    private final boolean itemsIsArray;
    private final int itemsSize;
    private final boolean hasAdditional;

    ArraySchemaSelector(JsonNode digest) {
        this.hasItems = digest.get("hasItems").booleanValue();
        this.itemsIsArray = digest.get("itemsIsArray").booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
        this.hasAdditional = digest.get("hasAdditional").booleanValue();
    }

    Iterable<JsonPointer> selectSchemas(int index) {
        if (!this.hasItems) {
            return this.hasAdditional ? ImmutableList.of((Object)ADDITIONAL_ITEMS) : Collections.emptyList();
        }
        if (!this.itemsIsArray) {
            return ImmutableList.of((Object)ITEMS);
        }
        if (index < this.itemsSize) {
            return ImmutableList.of((Object)ITEMS.append(index));
        }
        return this.hasAdditional ? ImmutableList.of((Object)ADDITIONAL_ITEMS) : Collections.emptyList();
    }
}

