/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class RequiredKeywordValidator
extends KeywordValidator {
    private final Set<String> required;

    public RequiredKeywordValidator(JsonNode schema) {
        super("required", NodeType.OBJECT);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : schema.get(this.keyword)) {
            builder.add((Object)element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        Sets.SetView missing = Sets.difference(this.required, (Set)fields);
        if (missing.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("required property(ies) not found").addInfo("required", Ordering.natural().sortedCopy(this.required)).addInfo("missing", Ordering.natural().sortedCopy((Iterable)missing));
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "required: " + Ordering.natural().sortedCopy(this.required);
    }
}

