/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.draftv3.AbstractTypeKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import java.util.EnumSet;

public final class DraftV3TypeKeywordValidator
extends AbstractTypeKeywordValidator {
    public DraftV3TypeKeywordValidator(JsonNode schema) {
        super("type", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (this.typeSet.contains((Object)type)) {
            return;
        }
        ValidationReport schemaReport = report.copy();
        if (!this.schemas.isEmpty()) {
            this.trySchemas(context, schemaReport, instance);
            if (schemaReport.isSuccess()) {
                return;
            }
            if (schemaReport.hasFatalError()) {
                report.mergeWith(schemaReport);
                return;
            }
        }
        if (!this.typeSet.isEmpty()) {
            Message.Builder msg = this.newMsg().addInfo("found", type).addInfo("allowed", this.typeSet).setMessage("instance does not match any allowed primitive type");
            report.addMessage(msg.build());
        }
        report.mergeWith(schemaReport);
    }

    @Override
    public boolean alwaysTrue() {
        return EnumSet.complementOf(this.typeSet).isEmpty();
    }

    private void trySchemas(ValidationContext context, ValidationReport schemaReport, JsonNode instance) {
        ValidationReport report = schemaReport.copy();
        for (JsonNode schema : this.schemas) {
            ValidationReport subReport = report.copy();
            JsonValidator validator = context.newValidator(schema);
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) {
                return;
            }
            report.mergeWith(subReport);
        }
        schemaReport.mergeWith(report);
    }
}

