/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.metaschema.BuiltinSchemas;
import com.github.fge.jsonschema.metaschema.KeywordRegistry;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.metaschema.SchemaURIs;
import com.github.fge.jsonschema.ref.JsonFragment;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.schema.AddressingMode;
import com.github.fge.jsonschema.schema.SchemaBundle;
import com.github.fge.jsonschema.schema.SchemaContext;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.schema.SchemaRegistry;
import com.github.fge.jsonschema.uri.URIDownloader;
import com.github.fge.jsonschema.uri.URIManager;
import com.github.fge.jsonschema.validator.JsonValidatorCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class JsonSchemaFactory {
    private final SchemaRegistry registry;
    private final JsonRef defaultSchemaURI;
    private final Map<JsonRef, JsonValidatorCache> validatorCaches;

    public static JsonSchemaFactory defaultFactory() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private JsonSchemaFactory(Builder builder) {
        this.registry = new SchemaRegistry(builder.uriManager, builder.namespace, builder.addressingMode);
        this.registry.addBundle(builder.bundle);
        this.defaultSchemaURI = builder.defaultSchemaURI;
        ImmutableMap.Builder cacheBuilder = ImmutableMap.builder();
        Map map = builder.metaSchemas;
        for (Map.Entry entry : map.entrySet()) {
            JsonRef ref = (JsonRef)entry.getKey();
            JsonValidatorCache validatorCache = new JsonValidatorCache((MetaSchema)entry.getValue(), this.registry);
            cacheBuilder.put((Object)ref, (Object)validatorCache);
        }
        this.validatorCaches = cacheBuilder.build();
    }

    public JsonSchema fromSchema(JsonNode schema, String path) {
        SchemaContext schemaContext = this.registry.register(schema);
        JsonNode subSchema = JsonFragment.fromFragment(path).resolve(schemaContext.getSchema());
        return this.createSchema(schemaContext, subSchema);
    }

    public JsonSchema fromSchema(JsonNode schema) {
        return this.fromSchema(schema, "");
    }

    public JsonSchema fromURI(URI uri, String path) throws JsonSchemaException {
        SchemaContext schemaContext = this.registry.get(uri);
        JsonNode subSchema = JsonFragment.fromFragment(path).resolve(schemaContext.getSchema());
        return this.createSchema(schemaContext, subSchema);
    }

    public JsonSchema fromURI(URI uri) throws JsonSchemaException {
        return this.fromURI(uri, "");
    }

    public JsonSchema fromURI(String str) throws JsonSchemaException {
        return this.fromURI(URI.create(str), "");
    }

    public JsonSchema fromURI(String str, String path) throws JsonSchemaException {
        return this.fromURI(URI.create(str), path);
    }

    private JsonSchema createSchema(SchemaContext schemaContext, JsonNode schema) {
        SchemaNode schemaNode = new SchemaNode(schemaContext, schema);
        JsonValidatorCache cache = this.getValidatorCache(schemaContext.getSchema());
        return new JsonSchema(cache, schemaNode);
    }

    private JsonValidatorCache getValidatorCache(JsonNode schema) {
        JsonRef ref;
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return this.validatorCaches.get(this.defaultSchemaURI);
        }
        try {
            ref = JsonRef.fromString(node.textValue());
            if (!this.validatorCaches.containsKey(ref)) {
                ref = this.defaultSchemaURI;
            }
        }
        catch (JsonSchemaException ignored) {
            ref = this.defaultSchemaURI;
        }
        return this.validatorCaches.get(ref);
    }

    public static final class Builder {
        private AddressingMode addressingMode = AddressingMode.CANONICAL;
        private JsonRef defaultSchemaURI = SchemaURIs.draftV3HyperSchema();
        private final Map<JsonRef, MetaSchema> metaSchemas;
        private final URIManager uriManager = new URIManager();
        private URI namespace = URI.create("");
        private final SchemaBundle bundle = new SchemaBundle();

        public Builder() {
            this.metaSchemas = Maps.newHashMap();
            for (BuiltinSchemas builtin : BuiltinSchemas.values()) {
                JsonRef ref = JsonRef.fromURI(builtin.getURI());
                MetaSchema metaSchema = MetaSchema.copyOf(builtin);
                this.metaSchemas.put(ref, metaSchema);
            }
        }

        public Builder registerScheme(String scheme, URIDownloader downloader) {
            this.uriManager.registerScheme(scheme, downloader);
            return this;
        }

        public Builder unregisterScheme(String scheme) {
            this.uriManager.unregisterScheme(scheme);
            return this;
        }

        public Builder addressingMode(AddressingMode addressingMode) {
            this.addressingMode = addressingMode;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = URI.create(namespace);
            return this;
        }

        public Builder addRedirection(String from, String to) {
            this.uriManager.addRedirection(from, to);
            return this;
        }

        @Deprecated
        public Builder addKeywordRegistry(JsonRef schemaURI, KeywordRegistry keywordRegistry, boolean byDefault) {
            Preconditions.checkNotNull((Object)schemaURI, (Object)"schema URI cannot be null");
            Preconditions.checkNotNull((Object)keywordRegistry, (Object)"keyword registry cannot be null");
            MetaSchema metaSchema = MetaSchema.builder().withURI(schemaURI.toString()).addKeywordRegistry(keywordRegistry).build();
            this.metaSchemas.put(schemaURI, metaSchema);
            if (byDefault) {
                this.defaultSchemaURI = schemaURI;
            }
            return this;
        }

        public Builder addMetaSchema(MetaSchema metaSchema, boolean byDefault) {
            JsonRef dollarSchema = metaSchema.getDollarSchema();
            this.metaSchemas.put(dollarSchema, metaSchema);
            if (byDefault) {
                this.defaultSchemaURI = dollarSchema;
            }
            return this;
        }

        public Builder addSchema(URI uri, JsonNode schema) {
            this.bundle.addSchema(uri, schema);
            return this;
        }

        public Builder addSchema(String uri, JsonNode schema) {
            this.bundle.addSchema(uri, schema);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this);
        }
    }
}

