/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.JsonSchemaTree;

public final class NotKeywordValidator
extends AbstractKeywordValidator {
    private static final JsonPointer PTR = JsonPointer.empty().append("not");

    public NotKeywordValidator(JsonNode digest) {
        super("not");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonSchemaTree tree = data.getSchema();
        ListProcessingReport subReport = new ListProcessingReport();
        tree.append(PTR);
        processor.process(subReport, data);
        tree.pop();
        if (subReport.isSuccess()) {
            report.error(this.newMsg(data).msg(KeywordValidationMessages.NOT_FAIL));
        }
    }

    @Override
    public String toString() {
        return "must not match subschema";
    }
}

