/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;

public final class EnumKeywordValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private final JsonNode values;

    public EnumKeywordValidator(JsonNode digest) {
        super("enum");
        this.values = digest.get(this.keyword);
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode node = data.getInstance().getCurrentNode();
        for (JsonNode enumValue : this.values) {
            if (!EQUIVALENCE.equivalent((Object)enumValue, (Object)node)) continue;
            return;
        }
        report.error(this.newMsg(data).msg(KeywordValidationMessages.VALUE_NOT_IN_ENUM).put(this.keyword, this.values).put("value", node));
    }

    @Override
    public String toString() {
        return this.keyword + '(' + this.values.size() + " possible values)";
    }
}

