/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.common;

import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.RhinoHelper;
import java.util.Collection;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, JsonSchemaTree tree) throws ProcessingException {
        String value = this.getNode(tree).textValue();
        if (!RhinoHelper.regexIsValid(value)) {
            report.error(this.newMsg(tree, SyntaxMessages.INVALID_REGEX_VALUE).put("value", value));
        }
    }
}

