/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.report;

import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;

public abstract class AbstractProcessingReport
implements ProcessingReport {
    protected LogLevel currentLevel = LogLevel.DEBUG;
    protected LogLevel logLevel = LogLevel.INFO;
    protected LogLevel exceptionThreshold = LogLevel.FATAL;

    public final void setLogLevel(LogLevel threshold) {
        this.logLevel = threshold;
    }

    public final void setExceptionThreshold(LogLevel threshold) {
        this.exceptionThreshold = threshold;
    }

    @Override
    public final void debug(ProcessingMessage msg) throws ProcessingException {
        this.log(msg.setLogLevel(LogLevel.DEBUG));
    }

    @Override
    public final void info(ProcessingMessage msg) throws ProcessingException {
        this.log(msg.setLogLevel(LogLevel.INFO));
    }

    @Override
    public final void warn(ProcessingMessage msg) throws ProcessingException {
        this.log(msg.setLogLevel(LogLevel.WARNING));
    }

    @Override
    public final void error(ProcessingMessage msg) throws ProcessingException {
        this.log(msg.setLogLevel(LogLevel.ERROR));
    }

    @Override
    public final boolean isSuccess() {
        return this.currentLevel.compareTo(LogLevel.ERROR) < 0;
    }

    public abstract void doLog(ProcessingMessage var1);

    @Override
    public final void log(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo(this.exceptionThreshold) >= 0) {
            throw new ProcessingException(message);
        }
        if (level.compareTo(this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo(this.logLevel) >= 0) {
            this.doLog(message.setLogLevel(level));
        }
    }
}

