/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.google.common.collect.Queues;
import java.util.Deque;

public abstract class BaseJsonTree
implements JsonTree {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final JsonNode baseNode;
    protected final Deque<JsonPointer> pointerStack = Queues.newArrayDeque();
    protected final Deque<JsonNode> nodeStack = Queues.newArrayDeque();
    protected JsonPointer currentPointer = JsonPointer.empty();
    protected JsonNode currentNode;

    protected BaseJsonTree(JsonNode baseNode) {
        this.baseNode = this.currentNode = baseNode;
    }

    @Override
    public final JsonNode getBaseNode() {
        return this.baseNode;
    }

    @Override
    public final JsonPointer getCurrentPointer() {
        return this.currentPointer;
    }

    @Override
    public final JsonNode getCurrentNode() {
        return this.currentNode;
    }

    protected final void pushPointer(JsonPointer pointer) {
        this.pointerStack.push(this.currentPointer);
        this.currentPointer = pointer;
    }

    protected final void pushNode(JsonNode node) {
        this.nodeStack.push(this.currentNode);
        this.currentNode = node;
    }

    protected final void popPointer() {
        this.currentPointer = this.pointerStack.pop();
    }

    protected final void popNode() {
        this.currentNode = this.nodeStack.pop();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();
}

