/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.schema.AddressingMode;
import com.github.fge.jsonschema.schema.SchemaBundle;
import com.github.fge.jsonschema.schema.SchemaContext;
import com.github.fge.jsonschema.uri.URIManager;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public final class SchemaRegistry {
    private final JsonRef namespace;
    private final LoadingCache<URI, SchemaContext> cache;
    private final AddressingMode addressingMode;

    public SchemaRegistry(final URIManager manager, URI namespace, final AddressingMode addressingMode) {
        this.addressingMode = addressingMode;
        this.namespace = JsonRef.fromURI(namespace);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, SchemaContext>(){

            public SchemaContext load(URI key) throws JsonSchemaException {
                return addressingMode.forSchema(key, manager.getContent(key));
            }
        });
    }

    public SchemaContext register(JsonNode schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        SchemaContext schemaContext = this.addressingMode.forSchema(schema);
        JsonRef ref = schemaContext.getLocator();
        if (ref.isAbsolute()) {
            this.cache.put((Object)ref.getLocator(), (Object)schemaContext);
        }
        return schemaContext;
    }

    public SchemaContext get(URI uri) throws JsonSchemaException {
        JsonRef ref = this.namespace.resolve(JsonRef.fromURI(uri));
        Message.Builder msg = Domain.REF_RESOLVING.newMessage().setFatal(true).setKeyword("N/A").addInfo("uri", ref);
        if (!ref.isAbsolute()) {
            throw new JsonSchemaException(msg.setMessage("URI is not absolute").build());
        }
        URI realURI = ref.toURI();
        try {
            return (SchemaContext)this.cache.get((Object)realURI);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            msg.addInfo("exception-class", cause.getClass().getName()).addInfo("exception-message", cause.getMessage()).setMessage("failed to load schema from URI");
            throw JsonSchemaException.wrap(msg.build(), cause);
        }
    }

    public void addBundle(SchemaBundle bundle) {
        Map<URI, JsonNode> map = bundle.getSchemas();
        for (Map.Entry<URI, JsonNode> entry : map.entrySet()) {
            URI uri = entry.getKey();
            JsonNode schema = entry.getValue();
            SchemaContext schemaContext = this.addressingMode.forSchema(uri, schema);
            this.cache.put((Object)uri, (Object)schemaContext);
        }
    }
}

