/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.syntax;

import com.github.fge.jsonschema.processing.LogLevel;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.Sets;
import java.util.Set;

final class SyntaxReport
extends ListProcessingReport {
    private final Set<JsonPointer> ignoredPaths = Sets.newLinkedHashSet();

    public SyntaxReport() {
        this.setLogLevel(LogLevel.DEBUG);
    }

    public void addIgnoredPath(JsonPointer pointer) {
        this.ignoredPaths.add(pointer);
    }

    public void injectMessages(ProcessingReport report) throws ProcessingException {
        for (ProcessingMessage message : this.messages) {
            report.log(message);
        }
    }

    public boolean hasIgnoredPath(JsonPointer target) {
        for (JsonPointer pointer : this.ignoredPaths) {
            if (!pointer.isParentOf(target)) continue;
            return true;
        }
        return false;
    }
}

