/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.old.syntax.SyntaxValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public final class URISyntaxChecker
extends AbstractSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        try {
            new URI(value);
        }
        catch (URISyntaxException ignored) {
            messages.add(this.newMsg().setMessage("not a valid URI").addInfo("found", value).build());
        }
    }
}

