/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.old.syntax.SyntaxChecker;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SyntaxValidator {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxValidator(MetaSchema metaSchema) {
        this.checkers = metaSchema.getSyntaxCheckers();
    }

    public void validate(List<Message> messages, JsonNode schema) {
        if (!schema.isObject()) {
            Message message = Domain.SYNTAX.newMessage().setKeyword("N/A").setMessage("illegal JSON Schema: not an object").addInfo("found", NodeType.getNodeType(schema)).build();
            messages.add(message);
            return;
        }
        HashSet keywords = Sets.newHashSet((Iterator)schema.fieldNames());
        keywords.retainAll(this.checkers.keySet());
        for (String keyword : keywords) {
            SyntaxChecker checker = this.checkers.get(keyword);
            checker.checkSyntax(this, messages, schema);
        }
    }
}

