/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.InetAddresses;

public final class IPV4FormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new IPV4FormatAttribute();
    private static final int IPV4_LENGTH = 4;

    private IPV4FormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 4) {
            return;
        }
        Message.Builder msg = IPV4FormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid IPv4 address");
        report.addMessage(msg.build());
    }
}

